/*
************************************************************************
*
*  ndio.h - public header for Ndio.c
*
*  Copyright (c) 1988 - 1996
*
*  Spectrospin AG, 8117 Faellanden Switzerland
*  Bruker Instruments Inc., Billerica Mass. 01821 USA
*  Bruker Analytische Messtechnik GmbH, D-76189 Karlsruhe
*  Bruker Franzen Analytik GmbH, D-28359 Bremen
*
*  All Rights Reserved
*
*  Date of last modification : 96/09/13
*  Pathname of SCCS file     : /sgiext/autopsy/app/include/ndio/SCCS/s.ndio.h
*  SCCS identification       : 1.1
*
*  Modifications :
*  <NAME>   <DATE>   <COMMENTS>
*
************************************************************************
*/

#ifndef _NDIO_H_
#define _NDIO_H_

#include <bool.h>
#include <ndio/ndio_types.h>
#include <ndio/ndio_header.h>

#define NDIO_ALL -1

typedef struct NdioStruct *NDIOHANDLE;

typedef int NDIOrange[2];

extern void NdioSetMemLimit(int memLimit);

extern void NdioInit(void);

extern NDIOHANDLE NdioRawOpen(char *fileName,
    NdioFileType type, int dim, int fileSizes[], int smxSizes[],
    NdioFileMode mode, BOOL bigEndian);

extern NDIOHANDLE NdioRawCreate(char *fileName,
    int dim, int fileSizes[], int smxSizes[],
    NdioFileMode mode, BOOL bigEndian);

extern NDIOHANDLE NdioCreate(char *fileName,
    int dim, int fileSizes[], int smxSizes[],
    NdioFileMode mode);

extern NDIOHANDLE NdioOpen(char *fileName, NdioFileMode mode);

extern NdioDataPtr NdioGet(NDIOHANDLE io,
    NDIOrange coordV[], NdioFileMode mode);

extern void NdioPut(NDIOHANDLE io,
    NdioDataPtr data, NdioFileMode mode);

extern NdioDataPtr NdioGetCompressed(NDIOHANDLE io,
    NDIOrange coordV[], NdioDataPtr dataP, int maxV[]);

extern void *NdioGetPar(NDIOHANDLE io, void *buf, int parId, int arrInd);

extern void *NdioSetPar(NDIOHANDLE io, void *buf, int parId, int arrInd);

extern void NdioClose(NDIOHANDLE io);

extern void NdioCleanup(void);

#endif  /* _NDIO_H_ */
