/*
************************************************************************
*
*   spec_segm.h - spectrum segmentation
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.spec_segm.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef SPEC_SEGM_H
#define SPEC_SEGM_H

#include <app/base_types.h>
#include <app/reg.h>
#include <app/spec_noise.h>
#include <app/spec_mask.h>

typedef void (* AppRegionApplyF) (AppRegionP regP, void *clientData);

extern int AppSegment(AppSpectrumP specP, AppMaskP inclP, AppMaskP exclP,
    AppNoiseP noiseP, float noiseLevel, float minLevel, int minSizeA[]);
/* Do segmentation of the given spectrum part.
   inclP describes the part of the spectrum used for segmentation,
   exclP can be used for excluding points within this part, e. g. near
   the diagonal. If NULL is passed, no points are excluded.
   noiseP is used for local noise calculation. If NULL is passed,
   the constant level passed as last argument is used, otherwise the
   local noise level will be multiplied with this number.
   A region will be created for all connected parts of the spectrum
   above this level, they are added to the list of regions of the
   spectrum.
   The minimal size (number of data points) in each direction is
   given in minSizeA.
   The number of new regions is returned. */

extern void AppRegionApply(AppSpectrumP specP,
    AppRegionApplyF applyF, void *clientData);
/* Call applyF for all regions of the spectrum. */

extern void AppRegionRemove(AppRegionP regP);
/* Destroy the given region and remove it from the list of regions. */

extern void AppRegionSubsegment(AppRegionP regP, float level, int coord[]);
/* Use only part of the region for further processing. The part is
   determined by starting at the given coordinates (normally a local
   maximum) and taking all connected points above the given level. */

#endif
