/*
************************************************************************
*
*   spec_mask.h - description of spectrum parts (boxes, diagonals etc.)
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/10/25
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.spec_mask.h
*   SCCS identification       : 1.5
*
************************************************************************
*/

#ifndef SPEC_MASK_H
#define SPEC_MASK_H

#include <app/base_types.h>
#include <app/spec_noise.h>

typedef struct AppMaskS *AppMaskP;

extern AppMaskP AppMaskPrepare(AppSpectrumP specP);
/* Prepare an empty mask.
   An opaque pointer is returned, it is passed to all functions that
   need maskss. */

extern void AppMaskBox(AppMaskP maskP, AppDataRange rangeA[]);
/* Set mask to a box with the given dimensions. */

extern void AppMaskDiagonal(AppMaskP maskP, AppMaskP inclP,
    AppNoiseP noiseP, float noiseLevel,
    char *unit, int dom1, int dom2);
/* Add the diagonal to the mask. If the second argument is
   non-NULL, only the part of the spectrum inside this mask is
   considered.
   noiseP is used for local noise calculation. If NULL is passed,
   the constant level passed as last argument is used, otherwise
   the local noise level will be multiplied with this number.
   unit gives the unit in which the calculation should be made,
   this will typically be "ppm". dom1 and dom2 specify the two
   domains that need to be exchanged to obtain the symmteric
   position, this is typically 0 and 1. */

extern void AppMaskBorder(AppMaskP maskP, AppMaskP inclP,
    AppNoiseP noiseP, float noiseLevel, int width);
/* Add regions starting from the border of the spectrum to the
   mask. If the second argument is non-NULL, only the part of
   the spectrum inside this mask is considered.
   width is the number of data points used for the border.
   noiseP is used for local noise calculation. If NULL is passed,
   the constant level passed as last argument is used, otherwise
   the local noise level will be multiplied with this number. */

extern BOOL AppMaskIsInside(AppMaskP maskP, int coord[]);
/* Check whether the given point is inside the mask. */

extern BOOL AppMaskIsEmpty(AppMaskP maskP);
/* Check whether the given mask is empty. */

extern void AppMaskGetRange(AppMaskP maskP, int coord[],
    int *leftP, int *rightP);
/* Return the range of the points within the mask for a given row. */

extern void AppMaskDestroy(AppMaskP maskP);
/* Free storage allocated in AppMaskPrepare(). */

#endif
