/*
************************************************************************
*
*   spec_access.h - open/close spectrum
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.spec_access.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef SPEC_ACCESS_H
#define SPEC_ACCESS_H

#include <app/base_types.h>

typedef void (* AppSpectrumReadF) (void *clientData, AppDataRange rangeA[],
    AppDataP dataA);

extern AppSpectrumP AppOpenSpectrum(int dim, int sizeA[],
    float offsA[], float swA[], AppDataType type,
    AppSpectrumReadF readF, void *clientData);
/* Prepare spectrum for use with other functions, the returned
   (opaque) pointer is used to identify the spectrum. dim gives the
   number of dimension, sizeA contains the sizes for all domains.
   offsA and swA contain the parameters (offsets and sweep widths)
   used by AppConvertSpectrumUnit().
   readF is a function that can be called for reading part of the
   spectrum. type indicates the type of data (int, float) that this
   function delivers, clientData is passed to the funtion at
   each invocation. */

extern void AppSetSpectrumSign(AppSpectrumP specP, int sign);
/* If sign is -1, all following calls to AppReadSpectrum will
   return data values with inverted sign, if it is +1, the data
   will have the original sign. */

extern void AppGetSpectrumInfo(AppSpectrumP specP, int *dimP, int sizeA[]);
/* Get number of dimensions and sizes of the spectrum.
   This function is convenient if the caller uses a higer-level
   funtion for opening the spectrum, and therefore doesn't have
   this information. */

extern void AppConvertSpectrumUnit(AppSpectrumP specP,
    float inCoord[], char *inUnit, float outCoord[], char *outUnit);
/* Convert units of spectrum coordinates. The coordinates in inCoord
   (unit inUnit) are converted to outUnit and stored in outCoord.
   Supported units are "point" and "ppm". */

extern void AppReadSpectrum(AppSpectrumP specP, AppDataRange rangeA[],
    AppDataP dataA);
/* Read the specified part of the spectrum, and fill the data into
   dataA, the type will be the one that was passed to AppOpenSpectrum.
   This function is convenient if the caller uses a higer-level
   funtion for opening the spectrum, and therefore doesn't have
   easy access otherwise. */

extern void AppCloseSpectrum(AppSpectrumP specP);
/* Free storage allocated in AppOpenSpectrum. */

#endif
