/*
************************************************************************
*
*   shape_list.h - manage list of shapes
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.shape_list.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef SHAPE_LIST_H
#define SHAPE_LIST_H

#include <app/base_types.h>
#include <app/shape.h>

typedef void (* AppShapeApplyF) (AppShapeP shapeP, void *clientData);

extern AppShapeP AppAddShape(AppSpectrumP specP, AppShapeP shapeP);
/* Add entry to the list of shapes of the spectrum. The function
   allocates memory for the structure and all members and copies
   them. Returns a pointer to the new list entry, only this pointer
   may be used as argument for AppRemoveShape(). */

extern void AppShapeApply(AppSpectrumP specP,
    AppShapeApplyF applyF, void *clientData);
/* Call applyF for all shapes in the list. */

extern int AppClusterShapes(AppSpectrumP specP, int domain,
    int clusterNo, float minDiff, float maxDiff);
/* Reduce the number of shapes of the given spectrum in the
   given domain by combining similar shapes. clusterNo gives
   the desired number of resulting shapes. The difference of
   two clusters will be at least minDiff, and only shapes
   with at most maxDiff difference will be in the same
   cluster. Returns the number of resulting shapes. */

extern void AppRemoveShape(AppShapeP shapeP);
/* Free memory associated with shape and remove it from the
   list of shapes. */

#endif
