/*
************************************************************************
*
*   shape.h - definitions for handling of line shapes
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.shape.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef SHAPE_H
#define SHAPE_H

#include <linlist.h>

typedef struct AppShapeS {
  int dimensionNo, domain;
  int startIndex, valueNo;
  float *valueA;
  float *errorA;
  float centerPosition, centerError;
  float amplitude, width, gaussFraction, lorentzFraction;
  int origLeft, origValueNo;
  LINLIST pointerList;
  float clusterDiff, otherDiff;
} *AppShapeP;

extern void AppShapeCalcPar(AppShapeP shapeP);
/* Approximate shape by combined Gauss/Lorentz, setting the
   corresponding fields in the structure. */

extern void AppShapeComplete(AppShapeP shapeP,
    int leftIndex, int rightIndex, float level);
/* Calculate additonal points on both sides of the shape so that
   it either extends to the given positions or falls below the
   given level. AppShapeCalcPar() must be called before using that
   function, so that the corresponding fields in the structure are
   set. */

extern void AppShapeCompleteLevel(AppShapeP shapeP, float level);
/* Calculate additonal points on both sides of the shape so that
   falls below the given level. AppShapeCalcPar() must be called
   before using that function, so that the corresponding fields in
   the structure are set. */

extern void AppShapeOriginal(AppShapeP shapeP);
/* Undo the effect of AppShapeComplete*() functions. */

extern float AppShapeCompare(AppShapeP shape1P, AppShapeP shape2P);
/* Give a measure of the difference of the two line shapes.
   0.0 means that they are identical, 1.0 that they are moderately
   different, larger values that they differ even more. */

extern void AppShapeCombine(AppShapeP shape1P, AppShapeP shape2P);
/* Combine (average) the two shapes into the first one. */

extern AppShapeP AppShapeCopy(AppShapeP shapeP);
/* Copy the given shape into newly allocated memory. */

extern void AppShapeDestroy(AppShapeP shapeP);
/* Free storage associated with shape. */

#endif
