/*
************************************************************************
*
*   reg_shape.h - calculate line shapes of spectrum region
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/21
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.reg_shape.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#ifndef REG_SHAPE_H
#define REG_SHAPE_H

#include <app/base_types.h>
#include <app/reg_data.h>
#include <app/shape.h>

extern void AppCalcShapes(AppRegionDataP regDataP, float *noiseA,
    AppShapeP shapeA, float *ampP, float *errP);
/* Calculate the line shapes that give the best approximation to
   the data in the region. An array with local noise values for
   each data point can be passed, noiseMagnitudeMax of the region
   descriptor is used for all data points if it is NULL.
   Returns the line shape for each dimension, the amplitude of the
   potential peak and the error. */

extern void AppExtendShape(AppRegionDataP regDataP, float *noiseA,
    AppShapeP shapeA, float amp,
    AppShapeP shapeP, int dom);
/* Add additional points at each side of shapeP if calculating them
   with the completion functions yields too high values.
   An array with local noise values for each data point can be passed,
   noiseMagnitudeMax of the region descriptor is used for all data
   points if it is NULL.
   AppShapeCalcPar() must be called for the shape before calling this
   function. */

extern void AppSubtractShapes(AppRegionDataP regDataP,
    AppShapeP shapeA, float amp);
/* Subtract the product of the given shapes (with the corresponding
   amplitude) from the region. */

#endif
