/*
************************************************************************
*
*   peak_symm.h - function definitons for peak list symmetrization
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.peak_symm.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef PEAK_SYMM_H
#define PEAK_SYMM_H

#include <app/peak.h>
#include <app/spec_noise.h>

extern void AppPeakSetSymmetric(AppSpectrumP specP, char *unit,
    int dom1, int dom2);
/* For all peaks in the list of the given spectrum, set the
   symmetricPeakP field to the closest peak on the other side of
   the diagonal and  the symmetricDist field to its distance from
   the perfectly symmetric position. unit gives the unit in which
   the calculation should be made, this will typically be "ppm".
   dom1 and dom2 specify the two domains that need to be exchanged
   to obtain the symmteric position, this is typically 0 and 1. */

extern void AppPeakSymmetrize(AppSpectrumP specP, char *unit,
    int dom1, int dom2, float dist, AppNoiseP noiseP, float noiseLevel);
/* For all peaks in the list of the given spectrum, modify the
   quality field to account for symmetry. unit gives the unit in which
   the calculation should be made, this will typically be "ppm".
   dom1 and dom2 specify the two domains that need to be exchanged
   to obtain the symmteric position, this is typically 0 and 1.
   dist is the maximal distance allowed from the perfectly symmetric
   position for a pair of peaks to be considered symmetric.
   noiseP is used for local when testing for intensity at the
   symmetric position. If NULL is passed, the constant level passed
   as last argument is used, otherwise the local noise level will
   be multiplied with this number.
   AppPeakSetSymmetric must be called before this function. */

#endif
