/*
************************************************************************
*
*   peak.h - type definiton for peak descriptor
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.peak.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef PEAK_H
#define PEAK_H

#include <app/base_types.h>
#include <app/shape.h>

typedef struct AppPeakS *AppPeakP;

struct AppPeakS {
  int dimensionNo;
  float positionA[APP_MAX_DIM];
  float amplitude;
  AppShapeP shapePA[APP_MAX_DIM];
  float symmetryErrorA[APP_MAX_DIM], uniformError;
  float integrationLevel;
  float quality;
  AppPeakP symmetricPeakP;
  float symmetricDist;
};

typedef void (* AppPeakApplyF) (AppPeakP peakP, void *clientData);

extern AppPeakP AppAddPeak(AppSpectrumP specP, AppPeakP peakP);
/* Add entry to the list of peaks of the spectrum. The function
   allocates memory for the structure and copies it (but not
   the shapes!). Returns a pointer to the new list entry, only
   this pointer may be used as argument for other functions. */

extern void AppPeakApply(AppSpectrumP specP,
    AppPeakApplyF applyF, void *clientData);
/* Call applyF for all peaks in the list. */

extern void AppPeakGetIntegral(AppPeakP peakP, float *integrP, float *errP);
/* Calculate and return the integral of the peak, together with an
   estimation of its error. */

extern void AppRemovePeak(AppPeakP peakP);
/* Free shapes and remove entry from the list of peaks. */

#endif
