/*
************************************************************************
*
*   deconv.h - deconvolute region
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.deconv.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef DECONV_H
#define DECONV_H

#include <app/base_types.h>
#include <app/reg.h>
#include <app/shape_list.h>

extern void AppDeconvolHint(AppShapeP shapePA[], float prob);
/* Give a hint about the probability that there is a peak for the
   given combination of shapes. */

extern void AppDeconvol(AppRegionP regP, float minLevel, float minMatch);
/* Perform deconvolution on the given region. The list of shapes
   for the corresponding spectrum is used for this operation.
   Only potential peaks that are at least a factor of minLevel
   above the noise level are considered. minMatch defines how
   large the match (minus the corresponding error) between a
   potential peak and the data has to be. With a value in the range
   of 0.5, only very well matching peaks are found, a value in the
   range of 0.0 will also find rather questionable peaks. Typical
   values are around the middle of these two values.
   Found peaks will be added to the peak list of the spectrum. */

#endif
