/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import model.components.basic.Particle;
import model.components.schedulers.PistonScheduler;
import model.components.schedulers.PressureScheduler;
import model.components.schedulers.Scheduler;
import model.components.schedulers.StageScheduler;
import model.components.schedulers.TemperatureScheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.UtilsUI;
import visualization.gui.components.MainStageController;

public class ExperimentRenderer {
    private MainStageController overlord;
    private ExperimentSimplePiston experiment;
    private int width;
    private int height;

    public ExperimentRenderer(ExperimentSimplePiston e, int width, int height, MainStageController overlordIn) {
        this.experiment = e;
        this.width = width;
        this.height = height;
        this.overlord = overlordIn;
    }

    private void drawBackground(Graphics2D context) {
        context.setPaint(Color.WHITE);
        context.fillRect(0, 0, this.width, this.height);
    }

    private void drawParticles(Graphics2D context) {
        Particle tmp;
        int n;
        if (Settings.plotAllParticles) {
            for (n = 0; n < this.experiment.getNumOfParticles(); ++n) {
                tmp = this.experiment.getParticleById(n);
                tmp.draw(context);
            }
        }
        if (!Settings.plotAllParticles) {
            for (n = 0; n < this.experiment.getNumOfParticles(); ++n) {
                if (n % Settings.delayBetweenPlottedParticles != 0) continue;
                tmp = this.experiment.getParticleById(n);
                tmp.draw(context);
            }
        }
    }

    private void drawPressureArrow(Graphics2D context) {
        int textWidth;
        String text;
        double pressure = this.experiment.pressure;
        Color colorText = Color.ORANGE;
        Color colorTextTooBig = Color.RED;
        Color colorArrow = Color.BLACK;
        String textPressure = String.format("External Pressure: %.0f Pa", pressure);
        String textPressureTooBig = String.format("External Pressure: %.0f Pa (too large to display)", pressure);
        String textPistonFixed = String.format("Piston fixed (external pressure would be %.0f Pa)", pressure);
        int textYOffset = 20;
        double arrowLineHeight = 100.0;
        double arrowHeadHeight = 30.0;
        double standardPressure = 9976.8;
        double arrowHeadWidthFactor = 1.2;
        double arrowMaxWidth = this.experiment.rightX - this.experiment.leftX;
        double pistonHeightTop = this.experiment.getComponentById(4).getPosition()[1];
        double middleOfPistonX = (this.experiment.rightX + this.experiment.leftX) / 2.0;
        double arrowLineWidth = arrowLineHeight / 2.0 * pressure / standardPressure;
        FontMetrics metrics = context.getFontMetrics(context.getFont());
        if (this.experiment.pistonMode != 0) {
            String text2 = textPistonFixed;
            int textWidth2 = metrics.stringWidth(text2);
            context.setPaint(colorText);
            context.drawString(text2, (int)(middleOfPistonX - (double)textWidth2 / 2.0), (int)pistonHeightTop + textYOffset);
            return;
        }
        if (arrowLineWidth >= arrowMaxWidth) {
            arrowLineWidth = arrowMaxWidth;
            text = textPressureTooBig;
            textWidth = metrics.stringWidth(text);
            context.setPaint(colorTextTooBig);
        } else {
            text = textPressure;
            textWidth = metrics.stringWidth(text);
            context.setPaint(colorText);
        }
        context.drawString(text, (int)(middleOfPistonX - (double)textWidth / 2.0), (int)pistonHeightTop + textYOffset);
        if (arrowLineWidth > 0.0) {
            double arrowHeadWidth = arrowLineWidth * arrowHeadWidthFactor;
            int[] xPoints = new int[]{(int)(middleOfPistonX - arrowLineWidth / 2.0), (int)(middleOfPistonX + arrowLineWidth / 2.0), (int)(middleOfPistonX + arrowLineWidth / 2.0), (int)(middleOfPistonX + arrowHeadWidth / 2.0), (int)middleOfPistonX, (int)(middleOfPistonX - arrowHeadWidth / 2.0), (int)(middleOfPistonX - arrowLineWidth / 2.0)};
            int[] yPoints = new int[]{(int)(pistonHeightTop - arrowHeadHeight - arrowLineHeight), (int)(pistonHeightTop - arrowHeadHeight - arrowLineHeight), (int)(pistonHeightTop - arrowHeadHeight), (int)(pistonHeightTop - arrowHeadHeight), (int)pistonHeightTop, (int)(pistonHeightTop - arrowHeadHeight), (int)(pistonHeightTop - arrowHeadHeight)};
            context.setPaint(colorArrow);
            context.drawPolygon(xPoints, yPoints, 7);
            context.fillPolygon(xPoints, yPoints, 7);
        }
    }

    private void drawColorBar(Graphics2D context, HashMap<String, Double> stats) {
        double temperature;
        int w = Settings.visualizationWidth;
        int w_shift = 150;
        int numCol = 256;
        int labelInterval = 32;
        int x = w - w_shift;
        int barWidth = 30;
        int y = 165;
        int yGap = 15;
        int barHeightIncrement = 2;
        int barHeight = barHeightIncrement * numCol;
        context.setFont(new Font("Arial", 1, 14));
        context.setColor(Color.BLACK);
        context.drawString("Temperature [K]", x - context.getFontMetrics().stringWidth("Temperature [K]") / 2 + barWidth / 2, y);
        for (int i = 0; i <= numCol; ++i) {
            temperature = (double)i * Settings.temperatureMaxColoring / (double)numCol;
            context.setColor(UtilsUI.quantitativeColors(temperature));
            context.fillRect(x, y + yGap + (barHeight - barHeightIncrement * i), barWidth, barHeightIncrement);
        }
        for (int i = 1; i <= numCol - 1; ++i) {
            if (i % labelInterval != 0) continue;
            temperature = (double)i * Settings.temperatureMaxColoring / (double)numCol;
            Font font = new Font("Arial", 0, 12);
            context.setFont(font);
            context.setColor(Color.WHITE);
            String temperatureLabel = String.format("%d", (int)temperature);
            context.drawString(temperatureLabel, x + barWidth / 2 - context.getFontMetrics(context.getFont()).stringWidth(temperatureLabel) / 2, y + yGap + (barHeight - barHeightIncrement * i) + context.getFontMetrics(font).getHeight() / 2);
        }
        if (Settings.allowHeating) {
            double temperatureHeater = stats.get("Temperature Heaters [K]");
            int yHeater = y + yGap + (int)((double)barHeight - temperatureHeater * (double)barHeight / Settings.temperatureMaxColoring + (double)(barHeightIncrement / 2));
            this.drawTemperatureTriangle(yHeater, x, barWidth, barWidth, temperatureHeater, "Heater", context, 1);
        }
        double temperatureParticle = stats.get("Average Temperature Particles [K]");
        int yParticle = y + yGap + (int)((double)barHeight - temperatureParticle * (double)barHeight / Settings.temperatureMaxColoring + (double)(barHeightIncrement / 2));
        this.drawTemperatureTriangle(yParticle, x, barWidth, barWidth, temperatureParticle, "Particles", context, -1);
    }

    private void drawTemperatureTriangle(int yPositionIn, int xPositionIn, int widthIn, int barWidthIn, double temperatureIn, String labelIn, Graphics2D context, int direction) {
        int[] xPoints = new int[]{xPositionIn -= (direction - 1) / 2 * barWidthIn, xPositionIn - direction * widthIn, xPositionIn - direction * widthIn};
        int[] yPoints = new int[]{yPositionIn, yPositionIn + widthIn / 2, yPositionIn - widthIn / 2};
        context.setPaint(UtilsUI.getTemperatureColor(temperatureIn));
        context.drawPolygon(xPoints, yPoints, 3);
        context.setPaint(UtilsUI.getTemperatureColor(temperatureIn));
        context.fillPolygon(xPoints, yPoints, 3);
        Font font = new Font("Arial", 0, 12);
        context.setFont(font);
        context.setColor(Color.BLACK);
        if (direction == 1) {
            context.drawString(labelIn, xPositionIn - widthIn - context.getFontMetrics(context.getFont()).stringWidth(labelIn) - 3, yPositionIn + context.getFontMetrics(font).getHeight() / 2);
        }
        if (direction == -1) {
            context.drawString(labelIn, xPositionIn + widthIn + 3, yPositionIn + context.getFontMetrics(font).getHeight() / 2);
        }
    }

    public void drawScale(Graphics2D contextDraw) {
        int w = Settings.visualizationWidth;
        int h = Settings.visualizationHeight;
        int barLength = 100;
        contextDraw.setFont(new Font("Arial", 0, 12));
        FontMetrics metrics = contextDraw.getFontMetrics(contextDraw.getFont());
        contextDraw.setColor(Color.BLACK);
        contextDraw.fillRect(w - barLength - 85, h - 55, barLength, 5);
        contextDraw.drawString(String.format("%.3f m", (double)barLength / Settings.pixelsInAMeter), w - (barLength + metrics.stringWidth(String.format("%.3f m", (double)barLength / Settings.pixelsInAMeter))) / 2 - 85, h - 35);
    }

    private void drawSchedulerStats(Graphics2D context) {
        context.setPaint(Color.BLACK);
        int numS = 0;
        for (int n = 0; n < this.experiment.getNumOfSchedulers(); ++n) {
            Scheduler s = this.experiment.getSchedulerById(n);
            if (!(s instanceof TemperatureScheduler) && !(s instanceof PressureScheduler) && !(s instanceof PistonScheduler) && !(s instanceof StageScheduler)) continue;
            ++numS;
        }
        int h = Settings.visualizationHeight;
        int yIncrement = 25;
        int yCurrent = 195;
        int xPosition = 60;
        if (numS == 0) {
            context.setFont(new Font("Arial", 1, 14));
            context.setColor(Color.BLACK);
            context.drawString("No schedulers in this experiment", xPosition - 30, yCurrent - 30);
        } else {
            context.setFont(new Font("Arial", 1, 14));
            context.setColor(Color.BLACK);
            context.drawString("Stages:", xPosition - 30, yCurrent - 30);
            context.setFont(new Font("Arial", 0, 11));
            context.setColor(Color.BLACK);
            int stageId = 1;
            for (int n = 0; n < this.experiment.getNumOfSchedulers(); ++n) {
                Scheduler ts;
                Scheduler s = this.experiment.getSchedulerById(n);
                if (s instanceof StageScheduler) {
                    ts = (StageScheduler)s;
                    context.setColor(Color.BLACK);
                    context.drawString(String.format("Stage %d: ", stageId) + s.toString() + " " + String.format("(time %.2f-%.2f s)", ts.getTime(), ((StageScheduler)ts).getTimeStop()), xPosition, yCurrent);
                    context.setColor(s.isHasFired() && s.isIsActive() ? UtilsUI.GREEN : (s.isHasFired() ? UtilsUI.GRAY : UtilsUI.RED));
                    context.fillRect(xPosition - 30, yCurrent - 15, 20, 20);
                    yCurrent += yIncrement;
                    ++stageId;
                }
                context.setColor(Color.BLACK);
                if (s instanceof TemperatureScheduler && ((TemperatureScheduler)(ts = (TemperatureScheduler)s)).isHeatingAllowed()) {
                    context.drawString(String.format("Temperature: %.2f K", ((TemperatureScheduler)ts).getTemperature()), xPosition, yCurrent);
                    yCurrent += yIncrement;
                }
                if (s instanceof PressureScheduler) {
                    ts = (PressureScheduler)s;
                    context.drawString(String.format("Pressure -> %.2f Pa", ((PressureScheduler)ts).getTargetPressure()), xPosition, yCurrent);
                    yCurrent += yIncrement;
                }
                if (!(s instanceof PistonScheduler)) continue;
                ts = (PistonScheduler)s;
                if (((PistonScheduler)ts).getPistonMode() == 1) {
                    context.drawString(String.format("Piston: fixed volume %.2f m^3", ((PistonScheduler)ts).getTargetVolume()), xPosition, yCurrent);
                }
                if (((PistonScheduler)ts).getPistonMode() == 2) {
                    context.drawString("Piston: fixed position", xPosition, yCurrent);
                }
                yCurrent += yIncrement;
            }
        }
    }

    public BufferedImage drawExperimentState(HashMap<String, Double> stats, String stage) {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        BufferedImage canvas = new BufferedImage(this.width, this.height, 5);
        Graphics2D contextDraw = (Graphics2D)canvas.getGraphics();
        contextDraw.setRenderingHints(renderingHints);
        this.drawBackground(contextDraw);
        this.drawTemperatureShading(contextDraw, stats);
        this.drawSchedulerStats(contextDraw);
        this.drawParticles(contextDraw);
        for (int e_id = 0; e_id < this.experiment.getNumComponents(); ++e_id) {
            this.experiment.getComponentById(e_id).draw(contextDraw);
        }
        this.drawTimeInfo(contextDraw, stats, stage);
        this.drawColorBar(contextDraw, stats);
        this.drawScale(contextDraw);
        this.drawAlerts(contextDraw, stats);
        this.drawPressureArrow(contextDraw);
        this.drawExchangeRange(contextDraw, stats);
        return canvas;
    }

    private void drawTemperatureShading(Graphics2D context, HashMap<String, Double> stats) {
        double[] volume = this.experiment.getLegalAreaSimpleExperiment();
        Color color = UtilsUI.setGreen(UtilsUI.setAlpha(UtilsUI.getTemperatureColor(stats.get("Average Temperature Particles [K]")), 45), 0);
        context.setColor(color);
        context.fillRect((int)volume[0], (int)volume[1], (int)(volume[3] - volume[0]), (int)(volume[4] - volume[1]));
    }

    private void drawExchangeRange(Graphics2D context, HashMap<String, Double> stats) {
        if (Settings.allowHeating) {
            double range = this.experiment.heaterParameter * this.experiment.getVolumeTotalSI() / this.experiment.getAreaTotalSI();
            double[] volume = this.experiment.getLegalAreaSimpleExperiment();
            context.setColor(UtilsUI.getTemperatureColor(stats.get("Temperature Heaters [K]")));
            context.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f));
            context.drawRect((int)(volume[0] + range), (int)(volume[1] + range), (int)(volume[3] - volume[0] - 2.0 * range), (int)(volume[4] - volume[1] - 2.0 * range));
        }
    }

    private void drawAlerts(Graphics2D context, HashMap<String, Double> stats) {
        if (stats.containsKey("# of particles moving too fast") && stats.get("# of particles moving too fast") > 1.0) {
            BufferedImage i = UtilsUI.getInstance().prepareImage("/visualization/resources/buttons/alert.png", 48, 48);
            context.drawImage(i, 25, 150, 48, 48, null);
            context.setFont(new Font("Arial", 1, 12));
            context.setColor(UtilsUI.RED);
            context.drawString(String.format("%d particles moving too fast", (int)stats.get("# of particles moving too fast").doubleValue()), 80, 177);
        }
    }

    private void drawTimeInfo(Graphics2D contextDraw, HashMap<String, Double> stats, String stage) {
        contextDraw.setFont(new Font("Arial", 1, 22));
        contextDraw.setColor(Color.BLACK);
        contextDraw.drawString(String.format("Simulation time: %.3f s", stats.get("Simulation time [s]")), 25, 50);
        contextDraw.drawString("Current stage: " + stage, 25, 75);
    }
}

