/*
 * Decompiled with CFR 0.152.
 */
package model.components.schedulers;

import model.components.schedulers.Scheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.components.MainStageController;

public class PressureScheduler
extends Scheduler<ExperimentSimplePiston> {
    private final boolean smoothTransition;
    private double initialPressure;
    private final double targetPressure;
    private final int firstStepID;
    private final int lastStepID;

    public PressureScheduler(String name, double targetPressureIn, double timeStartIn, double timeStopIn, MainStageController overlordIn, boolean smoothTransitionIn) {
        this.type = "Pressure";
        this.name = name;
        this.targetPressure = targetPressureIn;
        this.overlord = overlordIn;
        this.smoothTransition = smoothTransitionIn;
        this.firstStepID = (int)(timeStartIn / Settings.totalTime * (double)Settings.numberOfTimeSteps);
        this.lastStepID = (int)(timeStopIn / Settings.totalTime * (double)Settings.numberOfTimeSteps);
    }

    public double getTargetPressure() {
        return this.targetPressure;
    }

    public String toString() {
        if (this.initialPressure > 0.0) {
            return String.format("%s/Pressure Scheduler: %.2f -> %.2f Pa", this.name, this.initialPressure, this.targetPressure);
        }
        return String.format("%s/Pressure Scheduler: ? -> %.2f Pa", this.name, this.targetPressure);
    }

    @Override
    public void update(double timeIn) {
        int stepID = (int)timeIn;
        if (timeIn > (double)this.firstStepID) {
            this.hasFired = true;
        }
        if (this.smoothTransition) {
            if (this.firstStepID == stepID) {
                this.initialPressure = this.overlord.getExperiment().pressure;
            }
            boolean bl = this.isActive = this.firstStepID <= stepID && this.lastStepID >= stepID;
            if (this.isActive && (double)(stepID - this.firstStepID) <= 0.75 * (double)(this.lastStepID - this.firstStepID)) {
                double tmpCoef = 1.0 - (double)(stepID - this.firstStepID) / (0.75 * (double)(this.lastStepID - this.firstStepID));
                this.overlord.getExperiment().pressure = this.targetPressure - (this.targetPressure - this.initialPressure) * tmpCoef * tmpCoef;
            }
        } else if (this.firstStepID == stepID) {
            this.overlord.getExperiment().pressure = this.targetPressure;
        }
    }
}

