# change from FANTOM to AMBER nomenclature

DELETE/COFIMA Q*        # remove pseudoatoms

# AMBER ASP and GLU correspond to ASP- and GLU-
DELETE HD2 @ASP
DELETE HE2 @GLU

# rename protons
RENAME HB2  HB1  !@ALA
RENAME HB3  HB2  !@ALA
RENAME HG2  HG1
RENAME HG3  HG2
RENAME HD2  HD1  @ARG* @LYS* @PRO
RENAME HD3  HD2  @ARG* @LYS* @PRO
RENAME HE   HNE  @ARG*
RENAME HH1  HN11 @ARG*
RENAME HH11 HN11 @ARG+
RENAME HH12 HN12 @ARG+
RENAME HH21 HN21 @ARG*
RENAME HH22 HN22 @ARG*
RENAME HE2  HE1  @LYS*
RENAME HE3  HE2  @LYS*
RENAME HZ1  HNZ1 @LYS*
RENAME HZ2  HNZ2 @LYS*
RENAME HZ3  HNZ3 @LYS*
RENAME HD21 HND1 @ASN
RENAME HD22 HND2 @ASN
RENAME HG   HSG  @CYS
RENAME HE21 HNE1 @GLN
RENAME HE22 HNE2 @GLN
RENAME HD1  HND  @HI*
RENAME HD2  HD   @HI*
RENAME HE1  HE   @HI*
RENAME HE2  HNE  @HI*
RENAME HG1  HOG  @THR
RENAME HG21 HG1  @ILE @THR
RENAME HG22 HG2  @ILE @THR
RENAME HG23 HG3  @ILE @THR
RENAME HG12 HG4  @ILE
RENAME HG13 HG5  @ILE
RENAME HD11 HD1  @ILE @LEU
RENAME HD12 HD2  @ILE @LEU
RENAME HD13 HD3  @ILE @LEU
RENAME HD21 HD4  @LEU
RENAME HD22 HD5  @LEU
RENAME HD23 HD6  @LEU
RENAME HZ   HZ1  @PHE
RENAME HG   HOG  @SER
RENAME HD1  HD   @TRP
RENAME HE3  HE   @TRP
RENAME HE1  HNE  @TRP
RENAME HZ2  HZ1  @TRP
RENAME HZ3  HZ2  @TRP
RENAME HH2  HH   @TRP
RENAME HH   HOH  @TYR
RENAME HG11 HG1  @VAL
RENAME HG12 HG2  @VAL
RENAME HG13 HG3  @VAL
RENAME HG21 HG4  @VAL
RENAME HG22 HG5  @VAL
RENAME HG23 HG6  @VAL

# attach missing protons
ATTACH HN12 NE CZ NH1 HN11 1.01 119.8  180.0 @ARG
DELETE/COFIMA  HNZ2                          @LYS
ATTACH HNZ2 CD CE NZ  HNZ1 1.01 109.47 120.0 @LYS
ATTACH HNZ3 CD CE NZ  HNZ1 1.01 109.47 240.0 @LYS

# new residue names
CHANGE @ARG+ @ARG
CHANGE @ASP- @ASP
CHANGE @CYSS @CYX
CHANGE @GLU- @GLU
CHANGE @HIS  @HID
CHANGE @HIST @HIE
CHANGE @HIS+ @HIP
CHANGE @LYS+ @LYS

# generate connectivities
CONNECT

# disulphide bridges
LINK 2.5 SG @CYX SG @CYX

# attach "lone pairs" to sulphur atoms, AMBER conventions
ATTACH LP1 CA CB SG ~SG  0.679 96.7  98.0 @CYX
ATTACH LP2 CA CB SG ~SG  0.679 96.7 -98.0 @CYX
ATTACH LP1 CA CB SG  HSG 0.679 96.7  98.0 @CYS
ATTACH LP2 CA CB SG  HSG 0.679 96.7 -98.0 @CYS
ATTACH LP1 CB CG SD  CE  0.679 96.7  98.0 @MET
ATTACH LP2 CB CG SD  CE  0.679 96.7 -98.0 @MET

# terminal COO
RENAME O OA @LAST

# Lit.: FANTOM  Schaumann, T., Braun, W. & W"uthrich, K. (1990).
#               Biopolymers 29, in press.
#       AMBER   Weiner, P. K. & Kollman, P. A. (1981).
#               J. Comp. Chem. 2, p. 287-303
