/*
 * Decompiled with CFR 0.152.
 */
package model.physics;

import model.components.Recorder;
import model.components.advanced.PistonVertical;
import model.components.basic.Particle;
import model.components.core.VTLComponent;
import model.experiment.ExperimentSimplePiston;
import model.physics.core.UtilsMaths;
import settings.Settings;
import visualization.gui.components.MainStageController;
import visualization.main.GlobalClock;

public class SimplePhysics {
    public static final int x1 = 0;
    public static final int y1 = 1;
    public static final int z1 = 2;
    public static final int x2 = 3;
    public static final int y2 = 4;
    public static final int z2 = 5;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int left = 0;
    public static final int bottom = 1;
    public static final int front = 2;
    public static final int right = 3;
    public static final int top = 4;
    public static final int back = 5;
    private ExperimentSimplePiston experiment;
    private VTLComponent[] components = new VTLComponent[6];
    private MainStageController engine;

    public SimplePhysics(MainStageController engine) {
        this.experiment = engine.getExperiment();
        for (int n = 0; n < 6; ++n) {
            this.components[n] = this.experiment.getComponentById(n);
        }
        this.engine = engine;
    }

    public void nextStep() {
        for (int n = 0; n < this.experiment.getNumOfSchedulers(); ++n) {
            this.experiment.getSchedulerById(n).update(GlobalClock.t);
        }
        double dt = Settings.timePerStep;
        int n_particles = this.experiment.getNumOfParticles();
        Recorder recorder = (Recorder)this.experiment.getComponentById(7);
        PistonVertical piston = (PistonVertical)this.components[4];
        double pistonSpeedOld = piston.getV()[1];
        double pistonPositionOld = piston.getPosition()[1];
        double deltaWork = 0.0;
        double workReported = 0.0;
        double heatExchanged = 0.0;
        double heatReported = 0.0;
        double heatExchangeRange = this.experiment.heaterParameter * dt * this.experiment.getVolumeTotalSI() / this.experiment.getAreaTotalSI();
        double particleTotalMomentumChangeX = 0.0;
        double particleTotalMomentumChangeY = 0.0;
        double particleTotalMomentumChangeZ = 0.0;
        int nRandomizer = UtilsMaths.nextInt(n_particles);
        double height = Math.abs(this.experiment.bottomY - piston.pos[4]);
        double width = Math.abs(this.experiment.rightX - this.experiment.leftX);
        double depth = Math.abs(Settings.zBack - Settings.zFront);
        double chamberHeight = this.experiment.bottomY - this.experiment.topY;
        int tooFastParticles = 0;
        int numPistonColisions = 0;
        int totalNumCollisions = 0;
        for (int nParticle = 0; nParticle < n_particles; ++nParticle) {
            this.experiment.getParticleById(nParticle).update(dt);
        }
        double energyCheck = 0.0;
        for (int nDummy = 0; nDummy < n_particles; ++nDummy) {
            boolean tooFast = false;
            int nParticle = (nDummy + nRandomizer) % n_particles;
            Particle particle = this.experiment.getParticleById(nParticle);
            double[] position = particle.getPosition();
            double[] velocity = particle.getV();
            if (position[0] < this.experiment.leftX) {
                if (position[0] > this.experiment.leftX - width) {
                    position[0] = 2.0 * this.experiment.leftX - position[0];
                    particleTotalMomentumChangeX += particle.getM() * Math.abs(2.0 * velocity[0]);
                    velocity[0] = -velocity[0];
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (position[0] > this.experiment.rightX) {
                if (position[0] < this.experiment.rightX + width) {
                    position[0] = 2.0 * this.experiment.rightX - position[0];
                    particleTotalMomentumChangeX += particle.getM() * Math.abs(2.0 * velocity[0]);
                    velocity[0] = -velocity[0];
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (position[1] < piston.pos[4]) {
                if (position[1] > piston.pos[4] - height) {
                    if (this.experiment.pistonMode == 0) {
                        position[1] = 2.0 * piston.pos[4] - position[1];
                        double m1 = particle.getM();
                        double m2 = piston.getM();
                        double u1 = velocity[1];
                        double u2 = piston.getV()[1];
                        double v1 = (m1 * u1 + m2 * (2.0 * u2 - u1)) / (m1 + m2);
                        double v2 = (m2 * u2 + m1 * (2.0 * u1 - u2)) / (m1 + m2);
                        energyCheck += 0.5 * m1 * v1 * v1 + 0.5 * m2 * v2 * v2 - (0.5 * m1 * u1 * u1 + 0.5 * m2 * u2 * u2);
                        particleTotalMomentumChangeY += m1 * Math.abs(v1 - u1);
                        velocity[1] = v1;
                        particle.setV(velocity);
                        piston.setV(v2);
                    } else {
                        position[1] = 2.0 * piston.pos[4] - position[1];
                        particleTotalMomentumChangeY += particle.getM() * Math.abs(2.0 * velocity[1]);
                        velocity[1] = velocity[1] * -1.0;
                    }
                    ++numPistonColisions;
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (position[1] > this.experiment.bottomY) {
                if (position[1] < this.experiment.bottomY + height) {
                    position[1] = 2.0 * this.experiment.bottomY - position[1];
                    particleTotalMomentumChangeY += particle.getM() * Math.abs(2.0 * velocity[1]);
                    velocity[1] = velocity[1] * -1.0;
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (position[2] < Settings.zFront) {
                if (position[2] > Settings.zFront - depth) {
                    position[2] = 2.0 * Settings.zFront - position[2];
                    particleTotalMomentumChangeZ += particle.getM() * Math.abs(2.0 * velocity[2]);
                    velocity[2] = velocity[2] * -1.0;
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (position[2] > Settings.zBack) {
                if (position[2] < Settings.zBack + depth) {
                    position[2] = 2.0 * Settings.zBack - position[2];
                    particleTotalMomentumChangeZ += particle.getM() * Math.abs(2.0 * velocity[2]);
                    velocity[2] = velocity[2] * -1.0;
                    ++totalNumCollisions;
                } else {
                    tooFast = true;
                }
            }
            if (!tooFast) continue;
            ++tooFastParticles;
        }
        double F_ext = this.experiment.pressure * piston.getAreaSI();
        double accelerationFromOutside = F_ext / piston.getM();
        if (this.experiment.pistonMode == 0) {
            double piston_v = piston.getV()[1];
            double s_piston = piston_v * dt + 0.5 * accelerationFromOutside * dt * dt;
            piston.pos[1] = piston.pos[1] + s_piston * Settings.pixelsInAMeter;
            piston.pos[4] = piston.pos[4] + s_piston * Settings.pixelsInAMeter;
            piston.setV(piston_v + accelerationFromOutside * dt);
            deltaWork = -(F_ext * (piston.getPosition()[1] - pistonPositionOld) / Settings.pixelsInAMeter + 0.5 * piston.getM() * (piston.getV()[1] * piston.getV()[1] - pistonSpeedOld * pistonSpeedOld));
        } else if (this.experiment.pistonMode == 1) {
            double h = this.experiment.targetVolume / (0.5 * this.experiment.getYAreaSI()) * Settings.pixelsInAMeter;
            piston.pos[1] = this.experiment.bottomY - h - this.experiment.pistonThickness;
            piston.pos[4] = this.experiment.bottomY - h;
            piston.setV(0.0);
            deltaWork = 0.0;
        }
        if (height > chamberHeight) {
            piston.pos[4] = this.experiment.bottomY - chamberHeight;
            piston.pos[1] = piston.pos[4] - this.experiment.pistonThickness;
            piston.setV(0.0);
            deltaWork = 0.0;
        }
        if (height < chamberHeight * 0.05) {
            piston.pos[4] = this.experiment.bottomY - chamberHeight * 0.05;
            piston.pos[1] = piston.pos[4] - this.experiment.pistonThickness;
            piston.setV(0.0);
            deltaWork = 0.0;
        }
        this.experiment.internalPressure = (particleTotalMomentumChangeX + particleTotalMomentumChangeY + particleTotalMomentumChangeZ) / (dt * this.experiment.getAreaTotalSI());
        if (Settings.recordWork) {
            workReported = deltaWork;
        }
        double heat = 0.0;
        if (Settings.allowHeating) {
            for (int n = 0; n < n_particles; ++n) {
                heat += this.heaterInteraction(this.experiment.getParticleById(n), heatExchangeRange);
            }
            heatExchanged = heat;
            if (Settings.recordHeat) {
                heatReported = heat;
            }
        }
        int nPairs = (int)((double)n_particles * this.experiment.particleExchangeRate * dt / 2.0);
        for (int n = 0; n < nPairs; ++n) {
            int particleId2;
            int particleId1 = UtilsMaths.nextInt(n_particles);
            if (particleId1 == (particleId2 = UtilsMaths.nextInt(n_particles))) continue;
            this.particleHeatExchange(this.experiment.getParticleById(particleId1), this.experiment.getParticleById(particleId2));
        }
        double[] particleStats = this.experiment.getParticleStatistics(this.experiment.getParticles());
        double totalEnergy = particleStats[4] + UtilsMaths.getKineticEnergy(piston);
        double avgKineticEnergyAtomic = particleStats[5];
        recorder.tempParticles = avgKineticEnergyAtomic * 2.0 / 3.0 / 1.380649E-23;
        recorder.tempHeaters = this.experiment.tempHeater;
        recorder.internalPressure = this.experiment.internalPressure;
        recorder.externalPressure = this.experiment.pressure;
        recorder.Volume = this.experiment.getVolumeTotalSI();
        recorder.pVnRT = this.experiment.internalPressure * recorder.Volume / (this.experiment.numberMoles * 8.314463 * (avgKineticEnergyAtomic * 2.0 / 4.141947E-23));
        recorder.numberMoles = this.experiment.numberMoles;
        recorder.deltaHeatIntoSystem = heatExchanged / dt;
        recorder.totalHeatIntoSystem += heatExchanged;
        recorder.deltaWorkBySystem = deltaWork / dt;
        recorder.totalWorkBySystem += deltaWork;
        recorder.internalEnergy = 1.5 * this.experiment.numberMoles * 8.314463 * recorder.tempParticles;
        recorder.totalEnergy = totalEnergy;
        recorder.QOverT += heatExchanged / recorder.tempParticles;
        recorder.pistonVelocity = piston.getV()[1];
        recorder.averageVelocity = particleStats[0];
        recorder.stdVelocity = particleStats[2];
        recorder.maxVelocity = particleStats[1];
        recorder.energyChangeCollision += energyCheck;
        recorder.particlesTooFast = tooFastParticles;
        recorder.numPistonColisions = numPistonColisions;
        recorder.totalNumCollisions = totalNumCollisions;
        if (GlobalClock.systemTime > 0L) {
            recorder.cpuTotalTime = (double)(System.currentTimeMillis() - GlobalClock.systemTime) / 1000.0;
            recorder.cpuSimulationStepsPerSecond = GlobalClock.t / recorder.cpuTotalTime;
        }
        recorder.simulationTime = (double)((float)GlobalClock.t / (float)Settings.numberOfTimeSteps) * Settings.totalTime;
        recorder.heatForEfficiency += heatReported;
        recorder.workForEfficiency += workReported;
        recorder.heatCurrent += heatExchanged;
        recorder.workCurrent += deltaWork;
        recorder.currentStage = this.experiment.stage;
        GlobalClock.inc();
    }

    public void particleHeatExchange(Particle particleIn1, Particle particleIn2) {
        double[] g_i = UtilsMaths.normalizeVector(UtilsMaths.nextNorm(3));
        double[] v_hat_i = UtilsMaths.productScalarVector(Math.sqrt(-Math.log(UtilsMaths.nextUni())), g_i);
        double[] g_k = UtilsMaths.normalizeVector(UtilsMaths.nextNorm(3));
        double[] v_hat_k = UtilsMaths.productScalarVector(Math.sqrt(-Math.log(UtilsMaths.nextUni())), g_k);
        double scalingFactor = Math.sqrt((UtilsMaths.squaredNorm(particleIn1.getV()) + UtilsMaths.squaredNorm(particleIn2.getV())) / (UtilsMaths.squaredNorm(v_hat_i) + UtilsMaths.squaredNorm(v_hat_k)));
        particleIn1.setV(UtilsMaths.productScalarVector(scalingFactor, v_hat_i));
        particleIn2.setV(UtilsMaths.productScalarVector(scalingFactor, v_hat_k));
    }

    public double heaterInteraction(Particle particleIn, double rangeIn) {
        double[] legalArea = this.experiment.getLegalAreaSimpleExperiment();
        if (particleIn.getPosition()[0] - (rangeIn *= Settings.pixelsInAMeter) <= Math.min(legalArea[0], legalArea[3]) || particleIn.getPosition()[0] + rangeIn >= Math.max(legalArea[0], legalArea[3]) || particleIn.getPosition()[1] - rangeIn <= Math.min(legalArea[1], legalArea[4]) || particleIn.getPosition()[1] + rangeIn >= Math.max(legalArea[1], legalArea[4]) || particleIn.getPosition()[2] - rangeIn <= Math.min(legalArea[2], legalArea[5]) || particleIn.getPosition()[2] + rangeIn >= Math.max(legalArea[2], legalArea[5])) {
            double speedOld = particleIn.getSpeed();
            double energyNew = 2.0709735E-23 * this.experiment.tempHeater * -Math.log(1.0 - UtilsMaths.nextUni());
            double energyOld = 0.5 * this.experiment.atomMassInUnits * 1.660539E-27 * speedOld * speedOld;
            particleIn.setV(UtilsMaths.productScalarVector(Math.sqrt(energyNew / energyOld), particleIn.getV()));
            return (energyNew - energyOld) * particleIn.getM() / particleIn.getMAtomic();
        }
        return 0.0;
    }
}

