/*
************************************************************************
*
*   %M% - use Simplex algorithm for best fit with maximum norm
*
*   Copyright (c) 1994-95
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>

#include <simplex.h>

#define COEFF_NO 2
#define POINT_NO 8

#define ROW_NO (2 * POINT_NO + 2)
#define COL_NO (COEFF_NO + 2)

static void
fillMat(double **a)
{
  a[1][0] =  3.0; a[1][1] = -1.0; a[1][2] = -1.0;
  a[2][0] =  5.0; a[2][1] = -2.0; a[2][2] = -1.0;
  a[3][0] =  7.0; a[3][1] = -3.0; a[3][2] = -1.0;
  a[4][0] =  9.0; a[4][1] = -4.0; a[4][2] = -1.0;
  a[5][0] = 11.0; a[5][1] = -5.0; a[5][2] = -1.0;
  a[6][0] = 13.0; a[6][1] = -6.0; a[6][2] = -1.0;
  a[7][0] = 15.0; a[7][1] = -7.0; a[7][2] = -1.0;
  a[8][0] = 17.0; a[8][1] = -8.0; a[8][2] = -1.0;
}

main()
{
  double am[ROW_NO * COL_NO];
  double *a[ROW_NO];
  SimplexRes res;
  double sol[COEFF_NO + 1];
  double diff;
  int i, k;

  for (i = 0; i < ROW_NO; i++)
    a[i] = am + i * COL_NO;

  for (k = 0; k <= COEFF_NO; k++)
    a[0][k] = 0.0;
  a[0][COEFF_NO + 1] = -1.0;

  fillMat(a);

  for (i = 0; i < POINT_NO; i++) {
    a[1 + i][COEFF_NO + 1] = 1.0;
    for (k = 0; k <= COEFF_NO; k++)
      a[1 + POINT_NO + i][k] = a[1 + i][k];
    a[1 + POINT_NO + i][COEFF_NO + 1] = - 1.0;
  }

  res = Simplex(a, COEFF_NO + 1, 2 * POINT_NO, POINT_NO, POINT_NO, 0, sol);
  (void) printf("res = %d\n", res);

  for (k = 0; k < COEFF_NO + 1; k++)
    (void) printf("%8.5f ", sol[k]);
  (void) printf("\n");
  (void) printf("\n");

  fillMat(a);
  for (i = 0; i < POINT_NO; i++) {
    diff = a[1 + i][0];
    for (k = 0; k < COEFF_NO; k++)
      diff += a[1 + i][1 + k] * sol[k];
    (void) printf("%8.5f ", diff);
  }
  (void) printf("\n");

  return 0;
}
