/*
************************************************************************
*
*   %M% - test Powell's method
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <powell.h>

#include <stdio.h>
#include <math.h>

static int EvalCount = 0;

static float
func(float x[], int n, void *clientData)
{
  EvalCount++;
  return 5.0 + (x[0] - 2.0) * (x[0] - 2.0) +
      (x[1] - 3.0) * (x[1] - 3.0) +
      (x[2] - 4.0) * (x[2] - 4.0);
}

main()
{
  float x[3];

  x[0] = 0.0;
  x[1] = 0.0;
  x[2] = 0.0;

  (void) PowellMin(func, x, 3, NULL, 0.00001);
  (void) printf("%8.5f %8.5f %8.5f %d\n", x[0], x[1], x[2], EvalCount);

  return 0;
}
