/*
************************************************************************
*
*   %M% - use Powell's method for best fit with maximum norm
*
*   Copyright (c) 1994-95
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>

#include <least_sqr.h>
#include <powell.h>

#define COEFF_NO 2
#define POINT_NO 4

static int EvalCount = 0;

typedef struct {
  float **f;
  float *d;
} FitData;

static void
fillMat(float **f, float *d)
{
  f[0][0] = 1.0;
  f[1][0] = 2.0;
  f[2][0] = 3.0;
  f[3][0] = 4.0;

  f[0][1] = 1.0;
  f[1][1] = 1.0;
  f[2][1] = 1.0;
  f[3][1] = 1.0;

  d[0] = 3.0;
  d[1] = 5.0;
  d[2] = 7.0;
  d[3] = 8.0;
}

static float
func(float x[], int n, void *clientData)
{
  FitData *dataP = clientData;
  float maxDiff, diff;
  int i, k;

  maxDiff = 0.0;
  for (i = 0; i < POINT_NO; i++) {
    diff = dataP->d[i];
    for (k = 0; k < COEFF_NO; k++)
      diff -= x[k] * dataP->f[i][k];

    if (diff > maxDiff)
      maxDiff = diff;
    else if (- diff > maxDiff)
      maxDiff = - diff;
  }

  EvalCount++;

  return maxDiff;
}

int
main()
{
  float fm[POINT_NO * COEFF_NO];
  float *f[POINT_NO];
  float d[POINT_NO];
  float t[COEFF_NO];
  float sol[COEFF_NO];
  float r[POINT_NO];
  FitData data;
  int i, k;

  for (i = 0; i < POINT_NO; i++)
    f[i] = fm + i * COEFF_NO;

  fillMat(f, d);
  for (i = 0; i < POINT_NO; i++)
    d[i] = - d[i];
  LeastSqrMatTransf(f, COEFF_NO, POINT_NO, t);
  LeastSqrCalcSol(f, t, d, COEFF_NO, POINT_NO, sol, r);

  fillMat(f, d);
  data.f = f;
  data.d = d;

  for (k = 0; k < COEFF_NO; k++)
    (void) printf("%8.5f ", sol[k]);
  (void) printf("\n");
  (void) printf("-> %8.5f\n", func(sol, 2, &data));

  (void) PowellMin(func, sol, COEFF_NO, &data, 0.00001);

  for (k = 0; k < COEFF_NO; k++)
    (void) printf("%8.5f ", sol[k]);
  (void) printf("\n");
  (void) printf("-> %8.5f\n", func(sol, 2, &data));
  (void) printf("evaluations: %d\n", EvalCount);

  return 0;
}
