/*
************************************************************************
*
*   %M% - test non-linear least squares
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>
#include <math.h>

#include <marquardt.h>

#define PARAM_NO 5
#define POINT_NO 10

static void
calcFunc(void *xA, int xI, float *sol, int paramNo, float *yP, float dy[])
{
  float (*p)[3] = xA;
  float cx, sx, cy, sy, tx, ty;
  float x, y, z, xt, yt, r;

  cx = cos(sol[0]);
  sx = sin(sol[0]);
  cy = cos(sol[1]);
  sy = sin(sol[1]);
  tx = sol[2];
  ty = sol[3];
  r = sol[4];

  x = p[xI][0];
  y = p[xI][1];
  z = p[xI][2];

  xt = x * cy - (y * sx + z * cx) * sy + tx;
  yt = y * cx - z * sx + ty;

  dy[0] = 2 * xt * (- y * cx + z * sx) * sy +
	    2 * yt * (- y * sx - z * cx);
  dy[1] = 2 * xt * (- x * sy - (y * sx + z * cx) * cy);
  dy[2] = 2 * xt;
  dy[3] = 2 * yt;
  dy[4] = - 2 * r;

  *yP = xt * xt + yt * yt - r * r;
}

main()
{
  float p[POINT_NO][3];
  float sol[PARAM_NO];
  float rmsd;
  int i;

  p[0][0] =  0.0; p[0][1] =  2.1; p[0][2] =  0.0;
  p[1][0] =  1.0; p[1][1] =  0.0; p[1][2] = -2.0;
  p[2][0] =  3.0; p[2][1] =  2.0; p[2][2] =  0.0;
  p[3][0] =  7.0; p[3][1] = -2.1; p[3][2] =  0.0;
  p[4][0] =  8.0; p[4][1] =  0.0; p[4][2] =  2.1;
  p[5][0] = 10.0; p[5][1] =  2.0; p[5][2] =  0.0;
  p[6][0] = 12.0; p[6][1] =  0.0; p[6][2] = -2.0;
  p[7][0] = 13.0; p[7][1] =  0.0; p[7][2] =  2.0;
  p[8][0] = 15.0; p[8][1] =  0.0; p[8][2] = -2.1;
  p[9][0] = 19.0; p[9][1] = -2.0; p[9][2] =  0.0;

  sol[0] = 0.5;
  sol[1] = 0.5;
  sol[2] = 0.0;
  sol[3] = 0.0;
  sol[4] = 1.0;

  if (! Marquardt(calcFunc, p, POINT_NO, sol, PARAM_NO, &rmsd)) {
    (void) fprintf(stderr, "error\n");
    return 1;
  }

  for (i = 0; i < PARAM_NO; i++)
    (void) printf("sol[%d] = %8.5f\n", i, sol[i]);
  (void) printf("rmsd: %5.3f\n", rmsd);

  return 0;
}
