/*
************************************************************************
*
*   TestLS.c - test least squares
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.TestLS.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <least_sqr.h>

#define PARAM_NUM 2
#define EQU_NUM 6

main()
{
  float m[EQU_NUM * PARAM_NUM];
  float *c[EQU_NUM];
  float d[EQU_NUM];
  float t[PARAM_NUM];
  float x[PARAM_NUM];
  float r[EQU_NUM];
  int i;

  for (i = 0; i < EQU_NUM; i++)
    c[i] = m + i * PARAM_NUM;

  c[0][0] = 0.166667; c[0][1] = 0.181269;
  c[1][0] = 0.333333; c[1][1] = 0.393469;
  c[2][0] = 0.500000; c[2][1] = 0.632121;
  c[3][0] = 0.600000; c[3][1] = 0.776870;
  c[4][0] = 0.666667; c[4][1] = 0.864665;
  c[5][0] = 0.750000; c[5][1] = 0.950213;

  d[0] = -0.3;
  d[1] = -0.5;
  d[2] = -0.8;
  d[3] = -1.0;
  d[4] = -1.2;
  d[5] = -1.3;

  LeastSqrMatTransf(c, PARAM_NUM, EQU_NUM, t);
  LeastSqrCalcSol(c, t, d, PARAM_NUM, EQU_NUM, x, r);

  for (i = 0; i < PARAM_NUM; i++)
    (void) printf("x[%i] = %.6g\n", i, x[i]);
  (void) printf("\n");

  for (i = 0; i < EQU_NUM; i++)
    (void) printf("r[%i] = %.6g\n", i, r[i]);

  return 0;
}
