#include <stdio.h>
#include <stdlib.h>

#include <linlist.h>
#include "cluster.h"

#define DEBUG 1

typedef struct {
  int val;
  ClusterEntryP entryP;
} Data, *DataP;

static LINLIST DataL = NULL;

static void
addData(int val)
{
  Data data;
  DataP dataP;

  dataP = ListInsertLast(DataL, &data);
  dataP->val = val;
  dataP->entryP = ClusterAddEntry(dataP);
}

static void
buildDataList(void)
{
  DataL = ListOpen(sizeof(Data));

  addData(3);
  addData(10);
  addData(12);
  addData(20);
  addData(21);
  addData(24);
  addData(50);
  addData(55);
  addData(70);
  addData(95);
}

static void
addPairs(int maxDiff)
{
  DataP data1P, data2P;
  int diff;

  data1P = ListFirst(DataL);
  while (data1P != NULL) {
    data2P = ListNext(DataL, data1P);
    while (data2P != NULL) {
      diff = data1P->val - data2P->val;
      if (diff < 0)
	diff = - diff;
      if (diff > maxDiff)
	break;
      
      ClusterAddPair(data1P->entryP, data2P->entryP, (float) diff);

      data2P = ListNext(DataL, data2P);
    }

    data1P = ListNext(DataL, data1P);
  }
}

static void
printRes(int idx, int groupSize, void *entryP, void *clientData)
{
  DataP dataP = entryP;
  
  if (idx == 0)
    (void) printf("group:");

  (void) printf("%3d", dataP->val);

  if (idx == groupSize - 1)
    (void) printf("\n");
}

int
main(int argc, char *argv[])
{
  int groupNo, minDiff, maxDiff;
  int elimNo, i;

  if (argc < 4) {
    (void) fprintf(stderr, "usage: %s clusterNo minDiff maxDiff\n", argv[0]);
    return 1;
  }

  groupNo = atoi(argv[1]);
  minDiff = atoi(argv[2]);
  maxDiff = atoi(argv[3]);

  buildDataList();
  addPairs(maxDiff);

  ClusterCalc(groupNo, (float) minDiff, printRes, NULL);

  ListClose(DataL);

  return 0;
}
