/*
************************************************************************
*
*   %M% - test Brent algorithm
*
*   Copyright (c) 1994-96
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <brent.h>

#include <stdio.h>
#include <math.h>

static int EvalCount;

static float
func(float x, void *clientData)
{
  EvalCount++;

  return - exp(- (x - 0.3) * (x - 0.3));
}

static void
dfunc(float x, void *clientData, float *fP, float *dP)
{
  EvalCount++;

  *fP = - exp(- (x - 0.3) * (x - 0.3));
  *dP = *fP * (- 2.0 * (x - 0.3));
}

main()
{
  float x, y;

  EvalCount = 0;
  (void) BrentSolveMin(func, NULL, 0.0, 0.5, 1.0, 0.00001, &x, &y);
  (void) printf("%8.5f %8.5f %d\n", x, y, EvalCount);

  EvalCount = 0;
  (void) BrentSolveDerMin(dfunc, NULL, 0.0, 0.5, 1.0, 0.00001, &x, &y);
  (void) printf("%8.5f %8.5f %d\n", x, y, EvalCount);

  return 0;
}
