/*
************************************************************************
*
*   Polysurf.c - polynominal surface fitting
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/07/20
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.Polysurf.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <polysurf.h>

#include <stdio.h>
#include <stdlib.h>

#include <least_sqr.h>

void
PolysurfFit(float p[][3], int n, float coeff[], int degree)
/* coeff must have size (degree + 1) * (degree + 2) * (degree + 3) / 6 */
{
  int varNo = (degree + 1) * (degree + 2) * (degree + 3) / 6 - 1;
  float *m, **c, *tmp, *d;
  float px, pxy, pxyz;
  int varInd, ex, ey, ez;
  int i;

  m = malloc(varNo * n * sizeof(float));
  c = malloc(n * sizeof(float *));
  for (i = 0; i < n; i++)
    c[i] = m + varNo * i;
  tmp = malloc(varNo * sizeof(float));
  d = malloc(n * sizeof(float));

  for (i = 0; i < n; i++) {
    varInd = 0;
    px = 1.0;
    for (ex = 0; ex <= degree; ex++) {
      pxy = px;
      for (ey = 0; ex + ey <= degree; ey++) {
	pxyz = pxy;
	for (ez = 0; ex + ey + ez <= degree; ez++) {
	  if (ex + ey + ez > 0) {
	    c[i][varInd] = pxyz;
	    varInd++;
	  }
	  pxyz *= p[i][2];
	}
	pxy *= p[i][1];
      }
      px *= p[i][0];
    }
  }

  LeastSqrMatTransf(c, varNo, n, tmp);

  for (i = 0; i < n; i++)
    d[i] = 1.0;

  LeastSqrCalcSol(c, tmp, d, varNo, n, coeff + 1, NULL);
  coeff[0] = 1.0;

  free(m);
  free(c);
  free(tmp);
  free(d);
}

float
PolysurfResidue(float coeff[], int degree, float x[3])
{
  float px, pxy, pxyz, r;
  int varInd, ex, ey, ez;

  r = 0.0;
  varInd = 0;
  px = 1.0;
  for (ex = 0; ex <= degree; ex++) {
    pxy = px;
    for (ey = 0; ex + ey <= degree; ey++) {
      pxyz = pxy;
      for (ez = 0; ex + ey + ez <= degree; ez++) {
	r += coeff[varInd] * pxyz;
	varInd++;
	pxyz *= x[2];
      }
      pxy *= x[1];
    }
    px *= x[0];
  }

  return r;
}

void
PolysurfNormal(float coeff[], int degree, float x[3], float nv[3])
{
  float px, pxy, pxyz;
  int varInd, ex, ey, ez;

  nv[0] = 0.0;
  varInd = 0;
  for (ex = 0; ex <= degree; ex++) {
    if (ex == 0)
      px = 0.0;
    else if (ex == 1)
      px = 1.0;
    else
      px *= x[0];

    pxy = ex * px;

    for (ey = 0; ex + ey <= degree; ey++) {
      pxyz = pxy;
      for (ez = 0; ex + ey + ez <= degree; ez++) {
	nv[0] += coeff[varInd] * pxyz;
	varInd++;
	pxyz *= x[2];
      }
      pxy *= x[1];
    }
  }

  nv[1] = 0.0;
  varInd = 0;
  px = 1.0;
  for (ex = 0; ex <= degree; ex++) {
    for (ey = 0; ex + ey <= degree; ey++) {
      if (ey == 0)
	pxy = 0.0;
      else if (ey == 1)
	pxy = px;
      else
	pxy *= x[1];

      pxyz = ey * pxy;

      for (ez = 0; ex + ey + ez <= degree; ez++) {
	nv[1] += coeff[varInd] * pxyz;
	varInd++;
	pxyz *= x[2];
      }
    }
    px *= x[0];
  }

  nv[2] = 0.0;
  varInd = 0;
  px = 1.0;
  for (ex = 0; ex <= degree; ex++) {
    pxy = px;
    for (ey = 0; ex + ey <= degree; ey++) {
      for (ez = 0; ex + ey + ez <= degree; ez++) {
	if (ez == 0)
	  pxyz = 0.0;
	else if (ez == 1)
	  pxyz = pxy;
	else
	  pxyz *= x[2];

	nv[2] += ez * coeff[varInd] * pxyz;
	varInd++;
      }
      pxy *= x[1];
    }
    px *= x[0];
  }
}
