/*
************************************************************************
*
*   Polynom.c - polynom fitting and evaluation
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/07/20
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.Polynom.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <polynom.h>

#include <stdio.h>
#include <stdlib.h>

#include <least_sqr.h>

void
PolynomFit(float x[], float y[], int n, float coeff[], int degree)
{
  int coeffNo = degree + 1;
  float *m, **c, *tmp, *d;
  float p;
  int i, k;

  m = malloc(coeffNo * n * sizeof(float));
  c = malloc(n * sizeof(float *));
  for (i = 0; i < n; i++)
    c[i] = m + coeffNo * i;
  tmp = malloc(coeffNo * sizeof(float));
  d = malloc(n * sizeof(float));

  for (i = 0; i < n; i++) {
    p = 1.0;
    k = 0;
    for (;;) {
      c[i][k] = p;
      if (k == degree)
	break;
      p *= x[i];
      k++;
    }
  }

  LeastSqrMatTransf(c, coeffNo, n, tmp);

  for (i = 0; i < n; i++)
    d[i] = - y[i];

  LeastSqrCalcSol(c, tmp, d, coeffNo, n, coeff, NULL);

  free(m);
  free(c);
  free(tmp);
  free(d);
}

float
PolynomEval(float coeff[], int degree, float x)
{
  float y;
  int i;

  y = coeff[degree];
  for (i = degree - 1; i >= 0; i--)
    y = y * x + coeff[i];

  return y;
}

float
PolynomEvalDeriv(float coeff[], int degree, float x)
{
  float y;
  int i;

  y = degree * coeff[degree];
  for (i = degree - 1; i >= 1; i--)
    y = y * x + i * coeff[i];

  return y;
}
