/*
************************************************************************
*
*   queue.h - priority queue manager
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/11/26
*   Pathname of SCCS file     : /local/home/kor/molmol/tools/include/SCCS/s.queue.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _QUEUE_H_
#define _QUEUE_H_

typedef struct queueStruc *QUEUE;       /* Queue pointer */

typedef int (*QueueCompareFunc) (void *, void *);

extern QUEUE QueueOpen(int, QueueCompareFunc);
extern void QueueClose(QUEUE);
extern void QueuePut(QUEUE, void *);
extern void QueueGet(QUEUE, void *);
extern int QueueSize(QUEUE);

#endif  /* _QUEUE_H_ */
