/*
************************************************************************
*
*   marquardt.h - non-linear least squares by Marquardt's method
*
*   Copyright (c) 1994-96
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/06/28
*   Pathname of SCCS file     : /sgiext/molmol/tools/include/SCCS/s.marquardt.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <bool.h>

typedef void (*FitFunc) (float *, int, float *, int, float *, float *);

extern BOOL MarquardtStep(FitFunc, float *, float *, int, float *, int,
    float **, float **, float *, float *);

extern BOOL Marquardt(FitFunc, float *, float *, int, float *, int,
    float **, float *);
