/*
************************************************************************
*
*   hashtab.h - hash table manager
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/include/SCCS/s.hashtab.h
*   SCCS identification       : 1.1
*
************************************************************************
*/
#ifndef _HASHTAB_H_
#define _ASHTAB_H_

#include <bool.h>
#include <callback.h>

typedef struct hashTabStruc *HASHTABLE;       /* Hash Table pointer */

/* function pointer types */
typedef unsigned (*HashFunc) (void *, unsigned);
typedef int (*HashCompareFunc) (void *, void *);
typedef void (*HashApplyCB) (void *, void *);

extern HASHTABLE HashOpen(unsigned, unsigned, HashFunc, HashCompareFunc);
extern void HashClose(HASHTABLE);
extern void HashApply(HASHTABLE, HashApplyCB, void *);
extern void HashAddDestroyCB(HASHTABLE, DestroyCB, void *, FreeCldta);
extern void HashRemoveDestroyCB(HASHTABLE, DestroyCB, void *);
extern void *HashInsert(HASHTABLE, void *, BOOL);
extern void *HashSearch(HASHTABLE, void *);
extern void HashRemove(HASHTABLE, void *);
extern unsigned HashSize(HASHTABLE);

#endif  /* _HASHTAB_H_ */
