/*
************************************************************************
*
*   brent.h - root/minimum of function by Brent's method
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/04/23
*   Pathname of SCCS file     : /sgiext/molmol/tools/include/SCCS/s.brent.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <bool.h>

typedef float (*RootFunc) (float, void *);
typedef float (*MinFunc) (float, void *);
typedef void (*DerMinFunc) (float, void *, float *, float *);

extern BOOL BrentBracketRoot(RootFunc, void *,
    float *, float *);

extern BOOL BrentSolveRoot(RootFunc, void *,
    float, float, float,
    float *);

extern void BrentBracketMin(MinFunc, void *,
    float *, float *, float *,
    float *, float *, float *);

extern BOOL BrentSolveMin(MinFunc, void *,
    float, float, float, float,
    float *, float *);

extern BOOL BrentSolveDerMin(DerMinFunc, void *,
    float, float, float, float,
    float *, float *);
