/*
************************************************************************
*
*   PuVal.c - Pu wrapper functions for valuator box
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/pudev/SCCS/s.PuVal.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <pu_dev.h>

PuValuatorBox
PuCreateValuatorBox(char *title)
{
  return CurrPuDevP->createValuatorBox(title);
}

PuValuator
PuCreateValuator(PuValuatorBox box, char *name,
    float minVal, float maxVal, int digits, float initVal,
    PuValuatorCB valuatorCB, void *clientData, PuFreeCB freeCB)
{
  return CurrPuDevP->createValuator(box, name,
      minVal, maxVal, digits, initVal,
      valuatorCB, clientData, freeCB);
}

void
PuSwitchValuatorBox(PuValuatorBox box, BOOL onOff)
{
  CurrPuDevP->switchValuatorBox(box, onOff);
}
