/*
************************************************************************
*
*   prim_struc.h - data structures for primitives
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/prim/SCCS/s.prim_struc.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _PRIM_STRUC_H_
#define _PRIM_STRUC_H_

#include <bool.h>
#include <mat_vec.h>
#include <linlist.h>
#include <prim_hand.h>

typedef struct {
  Vec3 x;
  Vec3 dx;
  char *str;
} PrimText;

typedef struct {
  PrimDrawobjType type;
  PrimDrawobjStyle style;
  Vec3 *xA, *dxA;
  int pointNo;
} PrimDrawobj;

struct PrimObjS {
  int num;
  PrimType type;
  DhSpecP specP;
  union {
    PrimText text;
    PrimDrawobj drawobj;
  } u;
  unsigned *propTab;
  AttrP attrP;
};

extern LINLIST PrimListGet(void);

extern void PrimAddInvalidCB(PrimObjP);

#endif  /* _PRIM_STRUC_H_ */
