/*
************************************************************************
*
*   PrimDraw.c - draw primitives
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/prim/SCCS/s.PrimDraw.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <prim_draw.h>

#include <stdio.h>
#include <stdlib.h>

#include <sg.h>
#include <attr_struc.h>
#include "prim_struc.h"

static void
drawDrawobj(PrimObjP primP, float zoomFact)
{
  PrimDrawobj *objP = &primP->u.drawobj;
  Vec3 x[2], xr3[5], vz;
  float xr2[5][2];
  float fact, rad;
  int i;

  if (objP->style == PDS_INVISIBLE)
    return;

  /* pointNo is always 2 at the moment */

  if (primP->specP == NULL) {
    for (i = 0; i < 2; i++) {
      x[i][0] = objP->xA[i][0] + objP->dxA[i][0];
      x[i][1] = objP->xA[i][1] + objP->dxA[i][1];
    }
    switch (objP->type) {
      case PDT_LINE:
	SgDrawLine2D(x[0], x[1]);
	break;
      case PDT_RECT:
	xr2[0][0] = x[0][0];
	xr2[0][1] = x[0][1];
	xr2[1][0] = x[1][0];
	xr2[1][1] = x[0][1];
	xr2[2][0] = x[1][0];
	xr2[2][1] = x[1][1];
	xr2[3][0] = x[0][0];
	xr2[3][1] = x[1][1];
	xr2[4][0] = x[0][0];
	xr2[4][1] = x[0][1];
	SgDrawPolyline2D(xr2, 5);
	break;
      case PDT_CIRCLE:
	SgDrawCircle2D(x[0], Vec3DiffAbs(x[0], x[1]));
	break;
    }
  } else {
    for (i = 0; i < 2; i++) {
      Vec3Copy(x[i], objP->xA[i]);
      DhTransfVec(x[i], primP->specP);
      Vec3Scale(x[i], zoomFact);
      fact = SgGetDepthFact(0.0);
      x[i][0] += fact * objP->dxA[i][0];
      x[i][1] += fact * objP->dxA[i][1];
      x[i][2] += objP->dxA[i][2];
    }

    rad = primP->attrP->radius * zoomFact;

    switch (objP->type) {
      case PDT_LINE:
	if (objP->style == PDS_LINE)
	  SgDrawLine(x[0], x[1]);
	else if (objP->style == PDS_CYLINDER)
	  SgDrawCone(x[0], x[1], rad, rad,
	      SG_CONE_CAP_FLAT, SG_CONE_CAP_FLAT);
	else
	  SgDrawCone(x[0], x[1], rad, rad,
	      SG_CONE_CAP_ROUND, SG_CONE_CAP_ROUND);
	break;
      case PDT_RECT:
	Vec3Copy(xr3[0], x[0]);
	Vec3Copy(xr3[1], x[0]);
	xr3[1][0] = x[1][0];
	Vec3Copy(xr3[2], x[1]);
	Vec3Copy(xr3[3], x[1]);
	xr3[3][0] = x[0][0];

	if (objP->style == PDS_LINE) {
	  Vec3Copy(xr3[4], x[0]);
	  SgDrawPolyline(xr3, 5);
	} else {
	  SgDrawCone(xr3[0], xr3[1], rad, rad,
	      SG_CONE_CAP_ROUND, SG_CONE_CAP_ROUND);
	  SgDrawCone(xr3[1], xr3[2], rad, rad,
	      SG_CONE_CAP_ROUND, SG_CONE_CAP_ROUND);
	  SgDrawCone(xr3[2], xr3[3], rad, rad,
	      SG_CONE_CAP_ROUND, SG_CONE_CAP_ROUND);
	  SgDrawCone(xr3[3], xr3[0], rad, rad,
	      SG_CONE_CAP_ROUND, SG_CONE_CAP_ROUND);
	}
	break;
      case PDT_CIRCLE:
	vz[0] = 0.0;
	vz[1] = 0.0;
	vz[2] = 1.0;
	SgDrawCircle(x[0], vz, Vec3DiffAbs(x[0], x[1]));
	break;
    }
  }
}

void
PrimDraw(PrimObjP primP, float zoomFact)
{
  PrimText *textP;
  AttrP attrP;
  Vec3 x1;

  switch (primP->type) {
    case PT_TEXT:
      textP = &primP->u.text;

      if (primP->specP == NULL) {
	x1[0] = textP->x[0] + textP->dx[0];
	x1[1] = textP->x[1] + textP->dx[1];
	SgDrawText2D(x1, textP->str);
      } else {
	Vec3Copy(x1, textP->x);
	DhTransfVec(x1, primP->specP);
	Vec3Scale(x1, zoomFact);
	x1[2] += textP->dx[2];

	SgDrawText(x1, textP->dx, textP->str);
      }

      break;
    case PT_DRAWOBJ:
      drawDrawobj(primP, zoomFact);
      break;
  }
}
