/*
************************************************************************
*
*   OsMail.c - send E-mail
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/os/SCCS/s.OsMail.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <os_mail.h>

#include <stdio.h>
#include <string.h>

#include <dstr.h>
#include <prog_vers.h>
#include <contact_addr.h>

/* missing on IRIX 5.3 */
extern FILE *popen(const char *, const char *);
extern int pclose(FILE *);

BOOL
OsMail(char *subj, char *msg)
{
  DSTR cmd = DStrNew();
  FILE *fp;

  DStrAssignStr(cmd, "mail ");

#ifdef __sun
  DStrAppStr(cmd, "-s '");
  DStrAppStr(cmd, PROG_NAME);
  DStrAppStr(cmd, " ");
  DStrAppStr(cmd, subj);
  DStrAppStr(cmd, "' ");
#endif

  DStrAppStr(cmd, E_MAIL_ADDR);

  fp = popen(DStrToStr(cmd), "w");
  if (fp == NULL)
    return FALSE;

#ifndef __sun
  (void) fprintf(fp, "Subject: %s %s\n\n", PROG_NAME, subj);
#endif

  (void) fprintf(fp, "%s\n", msg);

  (void) pclose(fp);

  DStrFree(cmd);

  return TRUE;
}
