/*
************************************************************************
*
*   HomeDir.c - get home directory of user
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/os/SCCS/s.HomeDir.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <home_dir.h>

#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

static char *HomeDir = NULL;

char *
HomeDirGet(void)
{
  uid_t id;
  struct passwd *pwP;

  if (HomeDir != NULL)
    return HomeDir;

  id = getuid();
  pwP = getpwuid(id);
  if (pwP != NULL) {
    HomeDir = pwP->pw_dir;
  } else {
    HomeDir = getenv("HOME");
  }

  return HomeDir;
}
