/*
************************************************************************
*
*   CurrDir.c - get current directory
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/os/SCCS/s.CurrDir.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <curr_dir.h>

#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

static char *CurrDir = NULL;

char *
CurrDirGet(void)
{
  int size = 10;

  if (CurrDir != NULL)
    return CurrDir;

  CurrDir = malloc(size);
  for (;;) {
    if (getcwd(CurrDir, size) != NULL)
      return CurrDir;
    if (errno != ERANGE)
      break;
    size *= 2;
    CurrDir = realloc(CurrDir, size);
  }

  /* cannot get current directory, return root directory */
  CurrDir = realloc(CurrDir, 2);
  CurrDir[0] = '/';
  CurrDir[1] = '\0';

  return CurrDir;
}
