/*
************************************************************************
*
*   Debug.c - utility functions for debugging
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/07/20
*   Pathname of SCCS file     : /sgiext/molmol/src/main/SCCS/s.Debug.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#define STEP_NO 16

int
TestHeap(void)
{
  int i, size;
  void *p[STEP_NO];

  size = 1;
  for (i = 0; i < STEP_NO; i++) {
    p[i] = malloc(size);
    size *= 2;
  }
  for (i = 0; i < STEP_NO; i++)
    free(p[i]);

  return 0;
}

#ifdef __sgi

#include <gl.h>

static void
printMatrix(Matrix m)
{
  int i, k;

  for (i = 0; i < 4; i++) {
    for (k = 0; k < 4; k++)
      (void) printf("%g  ", m[i][k]);
    (void) printf("\n");
  }
  (void) printf("\n");
}

int
PrintMatrix(void)
{
  Matrix m;

  getmatrix(m);
  printMatrix(m);

  mmode(MPROJECTION);
  getmatrix(m);
  printMatrix(m);
  mmode(MVIEWING);

  return 0;
}

#endif
