/*
************************************************************************
*
*   expr_scan.h - expression scanner
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/expr/SCCS/s.expr_scan.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

typedef enum {
  ES_PLUS,
  ES_MINUS,
  ES_MUL,
  ES_DIV,
  ES_REM,
  ES_SQRT,
  ES_LOG,
  ES_EQU,
  ES_NEQ,
  ES_LEQ,
  ES_LSS,
  ES_GEQ,
  ES_GTR,
  ES_OR,
  ES_AND,
  ES_NOT,

  ES_DOT,
  ES_COLON,
  ES_LPAR,
  ES_RPAR,
  ES_COMMA,
  ES_RANGE,

  ES_END,
  ES_UNKNOWN,

  ES_INT,
  ES_FLOAT,
  ES_STR,
  ES_IDENT,

  ES_EXISTS,
  ES_ALL,

  ES_SPEC,
  ES_PEAK,
  ES_PRIM,

  ES_NUMBER,
  ES_NAME,
  ES_AMP,
  ES_SYMM,
  ES_UNIF,
  ES_QUAL,
  ES_SHIFT0,
  ES_SHIFT1,
  ES_SHIFT2,
  ES_SHIFT3,
  ES_SHIFT4,
  ES_WIDTH0,
  ES_WIDTH1,
  ES_WIDTH2,
  ES_WIDTH3,
  ES_WIDTH4,
  ES_ATTR
} ExprSym;

extern void ExprScanStart(char *);

extern ExprSym ExprScanGetSym(void);

extern int ExprScanGetInt(void);

extern float ExprScanGetFloat(void);

extern char *ExprScanGetStr(void);
