/*
************************************************************************
*
*   data_struc.h - data structures
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/data/SCCS/s.data_struc.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <mat_vec.h>
#include <linlist.h>
#include <app/spec_noise.h>
#include <data_hand.h>

typedef struct {
  DSTR fileName;
  AppSpectrumP appSpecP;
  DhSpecP noiseP;
  float maxVal;
} SpecFile;

typedef struct {
  AppNoiseP appNoiseP;
  DhSpecP specP;
} SpecNoise;

typedef struct {
  DhSpecP specP;
  AppRegionP appRegP;
} SpecRegion;

struct DhSpecS {
  SpecType type;
  int dim;
  int sizes[APP_MAX_DIM];
  int range[APP_MAX_DIM][2];
  int resol[APP_MAX_DIM];
  float scale;
  float level;

  union {
    SpecFile file;
    SpecNoise noise;
    SpecRegion reg;
  } u;

  float *val;
  Vec3 *points;
  Vec3 *norm;
  ContourLine *contA;
  int contNo;
  IsoSurface *surfA;
  int surfNo;

  DSTR name;
  int num;
  LINLIST peakL;  /* list of struct DhPeakS */
  Mat4 rotMat;
  Vec3 rotPoint;
  Vec3 transVect;
  unsigned *propTab;
  AttrP attrP;
  SpecAttrP specAttrP;
};

struct DhPeakS {
  AppPeakP appPeakP;
  DhSpecP specP;
  int num;
  unsigned *propTab;
  AttrP attrP;
};
