/*
************************************************************************
*
*   PropStand.c - handle standard (predefined) properties
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/data/SCCS/s.PropStand.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <data_hand.h>

#include <stdio.h>
#include <string.h>

#include <linlist.h>
#include <expr.h>
#include <par_names.h>
#include <setup_file.h>

typedef struct {
  DataEntityType entType;
  PropRefP refP;
  ExprP exprP;
} ListEntry;

static LINLIST ExprList = NULL;

void
DhClearPropStand(void)
{
  ListEntry *entryP;

  entryP = ListFirst(ExprList);
  while (entryP != NULL) {
    ExprFree(entryP->exprP);
    entryP = ListNext(ExprList, entryP);
  }

  ListClose(ExprList);
  ExprList = NULL;
}

static void
readList(void)
/* Read expressions from setup file. Silently ignores errors! */
{
  GFile gf;
  GFileRes res;
  ListEntry entry;
  char entName[14], propName[100], exprStr[500];
  ExprResType resType;

  if (ExprList != NULL)
    return;

  ExprList = ListOpen(sizeof(ListEntry));

  gf = SetupOpen(PN_PROP_DEF, "PropDef", FALSE);
  if (gf == NULL)
    return;
  
  while (! GFileEOF(gf)) {
    res = GFileReadStr(gf, entName, sizeof(entName));
    if (res != GF_RES_OK)
      break;

    if (strcmp(entName, "spec") == 0)
      entry.entType = DE_SPEC;
    else
      break;

    res = GFileReadStr(gf, propName, sizeof(propName));
    if (res != GF_RES_OK)
      break;

    entry.refP = PropGetRef(propName, TRUE);

    res = GFileReadQuotedStr(gf, exprStr, sizeof(exprStr));
    if (res != GF_RES_OK)
      break;

    entry.exprP = ExprCompile(entry.entType, exprStr, &resType);
    if (entry.exprP == NULL)
      continue;
    if (resType != ER_BOOL) {
      ExprFree(entry.exprP);
      continue;
    }

    (void) ListInsertLast(ExprList, &entry);
  }

  GFileClose(gf);
}

void
DhSpecSetPropStand(DhSpecP specP)
{
  ListEntry *entryP;
  ExprRes exprRes;

  readList();

  entryP = ListFirst(ExprList);
  while (entryP != NULL) {
    switch (entryP->entType) {
      case DE_SPEC:
	ExprEval(specP, entryP->exprP, &exprRes);
	if (exprRes.u.boolVal)
	  DhSpecSetProp(entryP->refP, specP, TRUE);
	break;
    }
    entryP = ListNext(ExprList, entryP);
  }
}
