/*
************************************************************************
*
*   DataSel.c - utility functions for selection
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/data/SCCS/s.DataSel.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <data_sel.h>

#include <stdio.h>

#include <linlist.h>

typedef struct {
  SelCB func;
} SelCBInfo;

typedef struct {
  void **selArr;
  int size;
  int selNo;
} SelInfo;

static PropRefP AllRefP = NULL;
static PropRefP SelRefP = NULL;
static LINLIST SelCBList = NULL;

void
SelAddCB(SelCB func)
{
  SelCBInfo entry;

  if (SelCBList == NULL)
    SelCBList = ListOpen(sizeof(SelCBInfo));
  
  entry.func = func;
  (void) ListInsertLast(SelCBList, &entry);
}

static void
callCB(DataEntityType entType, void *entP, SelKind kind)
{
  SelCBInfo *entryP;

  entryP = ListFirst(SelCBList);
  while (entryP != NULL) {
    entryP->func(entType, entP, kind);
    entryP = ListNext(SelCBList, entryP);
  }
}

static void
getRef(void)
{
  if (SelRefP == NULL) {
    AllRefP = PropGetRef(PROP_ALL, FALSE);
    SelRefP = PropGetRef(PROP_SELECTED, FALSE);
  }
}

static void
getSelSpec(DhSpecP specP, void *clientData)
{
  SelInfo *selInfoP = clientData;

  selInfoP->selNo++;
  if (selInfoP->selNo <= selInfoP->size)
    selInfoP->selArr[selInfoP->selNo - 1] = specP;
}

int
SelSpecGet(DhSpecP specPA[], int size)
{
  SelInfo selInfo;

  getRef();

  selInfo.selArr = (void **) specPA;
  selInfo.size = size;
  selInfo.selNo = 0;

  DhApplySpec(SelRefP, getSelSpec, &selInfo);

  return selInfo.selNo;
}

static void
getSelPeak(DhPeakP peakP, void *clientData)
{
  SelInfo *selInfoP = clientData;

  selInfoP->selNo++;
  if (selInfoP->selNo <= selInfoP->size)
    selInfoP->selArr[selInfoP->selNo - 1] = peakP;
}

int
SelPeakGet(DhPeakP peakPA[], int size)
{
  SelInfo selInfo;

  getRef();

  selInfo.selArr = (void **) peakPA;
  selInfo.size = size;
  selInfo.selNo = 0;

  DhApplyPeak(SelRefP, getSelPeak, &selInfo);

  return selInfo.selNo;
}

void
SelSpec(DhSpecP specP, SelKind kind)
{
  getRef();

  if (kind == SK_ADD) {
    DhSpecSetProp(SelRefP, specP, TRUE);
  } else if (kind == SK_REMOVE) {
    DhSpecSetProp(SelRefP, specP, FALSE);
  } else {
    DeselAllSpec();
    DhSpecSetProp(SelRefP, specP, TRUE);
  }

  callCB(DE_SPEC, specP, kind);
}

void
SelPeak(DhPeakP peakP, SelKind kind)
{
  getRef();

  if (kind == SK_ADD) {
    DhPeakSetProp(SelRefP, peakP, TRUE);
  } else if (kind == SK_REMOVE) {
    DhPeakSetProp(SelRefP, peakP, FALSE);
  } else {
    DeselAllPeak();
    DhPeakSetProp(SelRefP, peakP, TRUE);
  }

  callCB(DE_PEAK, peakP, kind);
}

static void
deselSpec(DhSpecP specP, void *clientData)
{
  DhSpecSetProp(SelRefP, specP, FALSE);
}

void
DeselAllSpec(void)
{
  getRef();
  DhApplySpec(AllRefP, deselSpec, NULL);
}

static void
deselPeak(DhPeakP peakP, void *clientData)
{
  DhPeakSetProp(SelRefP, peakP, FALSE);
}

void
DeselAllPeak(void)
{
  getRef();
  DhApplyPeak(AllRefP, deselPeak, NULL);
}
