/*
************************************************************************
*
*   ExSymmetrize.c - Symmetrize command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExSymmetrize.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>
#include <stdlib.h>

#include <app/peak_symm.h>
#include <arg.h>
#include <data_hand.h>

static float Distance = 0.01;
static int Dom1 = 0, Dom2 = 1;

static void
symmetrize(DhSpecP specP, void *clientData)
{
  AppSpectrumP appSpecP;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  AppPeakSetSymmetric(appSpecP, "ppm", Dom1, Dom2);
  AppPeakSymmetrize(appSpecP, "ppm", Dom1, Dom2,
      Distance, DhSpecGetNoise(specP), 1.0);
}

#define ARG_NUM 3

ErrCode
ExSymmetrize(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;

  arg[0].type = AT_INT;
  arg[1].type = AT_INT;
  arg[2].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Domain 1";
  arg[0].v.intVal = Dom1;
  arg[1].prompt = "Domain 2";
  arg[1].v.intVal = Dom2;
  arg[2].prompt = "Max. Dist.";
  arg[2].v.doubleVal = Distance;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  Dom1 = arg[0].v.intVal;
  Dom2 = arg[1].v.intVal;
  Distance = arg[2].v.doubleVal;

  ArgCleanup(arg, ARG_NUM);

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), symmetrize, NULL);

  return EC_OK;
}
