/*
************************************************************************
*
*   ExSegment.c - Segment command
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/10/25
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExSegment.c
*   SCCS identification       : 1.7
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>

#include <hashtab.h>
#include <app/spec_segm.h>
#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <graph_draw.h>

static float NoiseLevel = 1.0, MinLevel = 1.5;
static int DiagDom1 = 0, DiagDom2 = 1;
static ExclBorder = TRUE;
static int MinSizeA[APP_MAX_DIM] = {3, 3, 3, 3};

typedef struct {
  HASHTABLE hashTab;
  DhSpecP specP;
} RegData;

static unsigned
hashFunc(void *p, unsigned size)
{
  AppRegionP *appRegPP = p;

  return (unsigned) *appRegPP % size;
}

static int
compFunc(void *p1, void *p2)
{
  AppRegionP *appReg1PP = p1;
  AppRegionP *appReg2PP = p2;

  if (*appReg1PP == *appReg2PP)
    return 0;
  else
    return 1;
}

static void
getReg(AppRegionP appRegP, void *clientData)
{
  HASHTABLE hashTab = clientData;

  (void) HashInsert(hashTab, &appRegP, FALSE);
}

static void
checkReg(AppRegionP appRegP, void *clientData)
{
  RegData *dataP = clientData;
  DhSpecP regP;

  if (HashSearch(dataP->hashTab, &appRegP) != NULL)
    return;

  regP = DhRegNew(dataP->specP, appRegP);

  GraphSpecAdd(regP);
}

static void
segmSpec(DhSpecP specP, void *clientData)
{
  AppSpectrumP appSpecP;
  HASHTABLE oldTab;
  AppNoiseP appNoiseP;
  AppMaskP maskP, exclP;
  AppDataRange rangeA[APP_MAX_DIM];
  float noiseFact;
  RegData regData;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  /* Avoid that region is added multiple times if Segment is
     executed more than once. We build a hash table with the regions
     that we already have. */
  oldTab = HashOpen(997, sizeof(AppRegionP), hashFunc, compFunc);
  AppRegionApply(appSpecP, getReg, oldTab);

  appNoiseP = DhSpecGetNoise(specP);

  DhSpecGetRegion(specP, rangeA);
  maskP = AppMaskPrepare(appSpecP);
  AppMaskBox(maskP, rangeA);

  noiseFact = 1.0;

  for (;;) {
    exclP = AppMaskPrepare(appSpecP);

    if (ExclBorder)
      AppMaskBorder(exclP, maskP, appNoiseP, noiseFact * NoiseLevel, 1);
    if (DiagDom1 != DiagDom2)
      AppMaskDiagonal(exclP, maskP, appNoiseP, noiseFact * NoiseLevel,
	  "ppm", DiagDom1, DiagDom2);

    (void) AppSegment(appSpecP, maskP, exclP,
        appNoiseP, noiseFact * NoiseLevel, noiseFact * MinLevel, MinSizeA);

    AppMaskDestroy(maskP);
    maskP = exclP;

    if (AppMaskIsEmpty(maskP))
      break;

    noiseFact *= 1.4;
  }

  AppMaskDestroy(maskP);

  regData.hashTab = oldTab;
  regData.specP = specP;

  AppRegionApply(appSpecP, checkReg, &regData);

  HashClose(oldTab);
}

#define ARG_NUM 5

ErrCode
ExSegment(char *cmd)
{
  ArgDescr arg[ARG_NUM + APP_MAX_DIM];
  ErrCode errCode;
  DhSpecP specP;
  int selNo, dim, i;

  selNo = SelSpecGet(&specP, 1);
  if (selNo > 0)
    dim = DhSpecGetDim(specP);
  else
    dim = 2;

  arg[0].type = AT_DOUBLE;
  arg[1].type = AT_DOUBLE;
  arg[2].type = AT_INT;
  arg[3].type = AT_INT;
  arg[4].type = AT_INT;
  for (i = 0; i < dim; i++)
    arg[5 + i].type = AT_INT;

  ArgInit(arg, ARG_NUM + dim);

  arg[0].prompt = "Noise Level";
  arg[0].v.doubleVal = NoiseLevel;

  arg[1].prompt = "Min. Level";
  arg[1].v.doubleVal = MinLevel;

  arg[2].prompt = "Diag. Domain 1";
  arg[2].v.intVal = DiagDom1;

  arg[3].prompt = "Diag. Domain 2";
  arg[3].v.intVal = DiagDom2;

  arg[4].prompt = "Excl. Border";
  arg[4].v.intVal = ExclBorder;

  for (i = 0; i < dim; i++) {
    arg[5 + i].prompt = "Min. Size";
    arg[5 + i].v.intVal = MinSizeA[i];
  }

  errCode = ArgGet(arg, ARG_NUM + dim);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM + dim);
    return errCode;
  }

  NoiseLevel = arg[0].v.doubleVal;
  MinLevel = arg[1].v.doubleVal;
  DiagDom1 = arg[2].v.intVal;
  DiagDom2 = arg[3].v.intVal;
  ExclBorder = arg[4].v.intVal;
  for (i = 0; i < dim; i++)
    MinSizeA[i] = arg[5 + i].v.intVal;
  ArgCleanup(arg, ARG_NUM + dim);

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), segmSpec, NULL);

  GraphRedrawNeeded();

  return EC_OK;
}
