/*
************************************************************************
*
*   ExIdentify.c - Identify command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExIdentify.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <break.h>
#include <hashtab.h>
#include <app/shape_list.h>
#include <app/elim.h>
#include <pu.h>
#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <graph_draw.h>

static float MinLevel = 3.0;
static int MinSizeA[APP_MAX_DIM] = {3, 3, 3, 3};
static float MaxSplitA[APP_MAX_DIM] = {3.0, 1.0, 1.0, 1.0};
static float SplitDiff = 0.02;
static float MaxErrFact = 0.5;
static int SpecNo, SpecI;
static int PeakNo;

typedef struct {
  HASHTABLE hashTab;
  DhSpecP specP;
} PeakData;

static unsigned
hashFunc(void *p, unsigned size)
{
  AppPeakP *appPeakPP = p;

  return (unsigned) *appPeakPP % size;
}

static int
compFunc(void *p1, void *p2)
{
  AppPeakP *appPeak1PP = p1;
  AppPeakP *appPeak2PP = p2;

  if (*appPeak1PP == *appPeak2PP)
    return 0;
  else
    return 1;
}

static void
getPeak(AppPeakP appPeakP, void *clientData)
{
  HASHTABLE hashTab = clientData;

  (void) HashInsert(hashTab, &appPeakP, FALSE);
}

static void
getSpecPeaks(DhSpecP specP, void *clientData)
{
  HASHTABLE hashTab = clientData;
  AppSpectrumP appSpecP;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  AppPeakApply(appSpecP, getPeak, hashTab);
}

static void
checkPeak(AppPeakP appPeakP, void *clientData)
{
  PeakData *dataP = clientData;

  if (HashSearch(dataP->hashTab, &appPeakP) != NULL)
    return;

  (void) DhPeakNew(dataP->specP, appPeakP);

  PeakNo++;

}

static void
checkSpecPeaks(DhSpecP specP, void *clientData)
{
  HASHTABLE hashTab = clientData;
  AppSpectrumP appSpecP;
  PeakData peakData;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  peakData.hashTab = hashTab;
  peakData.specP = specP;

  AppPeakApply(appSpecP, checkPeak, &peakData);
}

static void
elimAll(DhSpecP regP, void *clientData)
{
  AppRegionP appRegP;
  char buf[50];

  SpecI++;

  if (DhSpecGetType(regP) != ST_REGION)
    return;

  if (BreakCheck(1))
    return;

  (void) sprintf(buf, "Identify: %5d / %5d\n", SpecI, SpecNo);
  PuSetTextField(PU_TF_STATUS, buf);

  appRegP = DhRegGetApp(regP);
  AppRegionPushState(appRegP, APP_PUSH_DATA | APP_PUSH_MAX_LIST);
  PeakNo = 0;
  AppElimAll(appRegP, MinLevel, MinSizeA, MaxSplitA, SplitDiff, MaxErrFact);
  AppRegionPopState(appRegP);
}

#define ARG_NUM 3

ErrCode
ExIdentify(char *cmd)
{
  ArgDescr arg[ARG_NUM + 2 * APP_MAX_DIM];
  ErrCode errCode;
  DhSpecP specP;
  int selNo, dim, i;
  PropRefP refP;
  HASHTABLE oldTab;

  selNo = SelSpecGet(&specP, 1);
  if (selNo > 0)
    dim = DhSpecGetDim(specP);
  else
    dim = 2;

  arg[0].type = AT_DOUBLE;
  for (i = 0; i < dim; i++)
    arg[1 + i].type = AT_INT;
  for (i = 0; i < dim; i++)
    arg[1 + dim + i].type = AT_DOUBLE;
  arg[1 + 2 * dim].type = AT_DOUBLE;
  arg[2 + 2 * dim].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM + 2 * dim);

  arg[0].prompt = "Min. Level.";
  arg[0].v.doubleVal = MinLevel;

  for (i = 0; i < dim; i++) {
    arg[1 + i].prompt = "Min. Size";
    arg[1 + i].v.intVal = MinSizeA[i];
  }

  for (i = 0; i < dim; i++) {
    arg[1 + dim + i].prompt = "Max. Split";
    arg[1 + dim + i].v.doubleVal = MaxSplitA[i];
  }

  arg[1 + 2 * dim].prompt = "Split Diff.";
  arg[1 + 2 * dim].v.doubleVal = SplitDiff;

  arg[2 + 2 * dim].prompt = "Max. Err. Fact.";
  arg[2 + 2 * dim].v.doubleVal = MaxErrFact;

  errCode = ArgGet(arg, ARG_NUM + 2 * dim);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM + 2 * dim);
    return errCode;
  }

  MinLevel = arg[0].v.doubleVal;
  for (i = 0; i < dim; i++)
    MinSizeA[i] = arg[1 + i].v.intVal;
  for (i = 0; i < dim; i++)
    MaxSplitA[i] = arg[1 + dim + i].v.doubleVal;
  SplitDiff = arg[1 + 2 * dim].v.doubleVal;
  MaxErrFact = arg[2 + 2 * dim].v.doubleVal;

  ArgCleanup(arg, ARG_NUM + 2 * dim);

  refP = PropGetRef(PROP_SELECTED, FALSE);

  oldTab = HashOpen(997, sizeof(AppPeakP), hashFunc, compFunc);
  DhApplySpec(refP, getSpecPeaks, oldTab);

  BreakActivate(TRUE);

  SpecNo = SelSpecGet(NULL, 0);
  SpecI = 0;
  DhApplySpec(refP, elimAll, NULL);
  
  BreakActivate(FALSE);

  DhApplySpec(refP, checkSpecPeaks, oldTab);

  HashClose(oldTab);
  GraphRedrawNeeded();

  return EC_OK;
}
