/*
************************************************************************
*
*   ExClustShape.c - ClusterShape command
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExClustShape.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>

#include <app/shape_list.h>
#include <pu.h>
#include <arg.h>
#include <data_hand.h>

static int Domain = 0, ClusterNo = 50;
static float MinDiff = 0.02, MaxDiff = 0.2;

static void
clusterShape(DhSpecP specP, void *clientData)
{
  AppSpectrumP appSpecP;
  int resNo;
  char buf[30];

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  resNo = AppClusterShapes(appSpecP, Domain, ClusterNo, MinDiff, MaxDiff);

  (void) sprintf(buf, "clusters: %d", resNo);
  PuSetTextField(PU_TF_STATUS, buf);
}

#define ARG_NUM 4

ErrCode
ExClusterShape(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;

  arg[0].type = AT_INT;
  arg[1].type = AT_INT;
  arg[2].type = AT_DOUBLE;
  arg[3].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Domain";
  arg[0].v.intVal = Domain;

  arg[1].prompt = "Cluster #";
  arg[1].v.intVal = ClusterNo;

  arg[2].prompt = "Min. Diff.";
  arg[2].v.doubleVal = MinDiff;

  arg[3].prompt = "Max. Diff.";
  arg[3].v.doubleVal = MaxDiff;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  Domain = arg[0].v.intVal;
  ClusterNo = arg[1].v.intVal;
  MinDiff = arg[2].v.doubleVal;
  MaxDiff = arg[3].v.doubleVal;

  ArgCleanup(arg, ARG_NUM);

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), clusterShape, NULL);

  return EC_OK;
}
