/*
************************************************************************
*
*   ExViewAngle.c - ViewAngle command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExViewAngle.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <sg.h>
#include <arg.h>
#include <par_names.h>
#include <par_hand.h>
#include <graph_draw.h>

#define ARG_NUM 1

ErrCode
ExViewAngle(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  float ang;

  arg[0].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "View Angle";
  arg[0].v.doubleVal = ParGetDoubleVal(PN_VIEW_ANGLE);

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  ang = arg[0].v.doubleVal;
  ArgCleanup(arg, ARG_NUM);

  ParSetDoubleVal(PN_VIEW_ANGLE, ang);
  SgSetViewAngle(ang);

  SgUpdateView();
  GraphRedrawNeeded();

  return EC_OK;
}
