/*
************************************************************************
*
*   ExScale.c - Scale command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExScale.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <arg.h>
#include <data_hand.h>
#include <graph_draw.h>

static void
setScale(DhSpecP specP, void *clientData)
{
  float *scaleP = clientData;

  DhSpecSetScale(specP, *scaleP);
}

ErrCode
ExScale(char *cmd)
{
  ArgDescr arg;
  ErrCode errCode;
  float scale;

  arg.type = AT_DOUBLE;

  ArgInit(&arg, 1);

  arg.prompt = "Scale Factor";
  arg.v.doubleVal = 1.0;

  errCode = ArgGet(&arg, 1);
  if (errCode != EC_OK) {
    ArgCleanup(&arg, 1);
    return errCode;
  }

  scale = arg.v.doubleVal;

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), setScale, &scale);

  ArgCleanup(&arg, 1);

  GraphRedrawNeeded();

  return EC_OK;
}
