/*
************************************************************************
*
*   ExDrawSize.c - DrawSize command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExDrawSize.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <pu.h>
#include <arg.h>
#include <par_names.h>
#include <par_hand.h>

#define ARG_NUM 3

ErrCode
ExDrawSize(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  EnumEntryDescr enumEntry[3];
  ErrCode errCode;
  int width, height;

  arg[0].type = AT_ENUM;
  arg[1].type = AT_INT;
  arg[2].type = AT_INT;

  ArgInit(arg, ARG_NUM);

  enumEntry[0].str = "set";
  enumEntry[0].onOff = TRUE;
  enumEntry[1].str = "save";
  enumEntry[1].onOff = FALSE;
  enumEntry[2].str = "restore";
  enumEntry[2].onOff = FALSE;

  arg[0].prompt = "Operation";
  arg[0].u.enumD.entryP = enumEntry;
  arg[0].u.enumD.n = 3;
  arg[0].v.intVal = 0;

  arg[1].prompt = "Width";
  arg[1].optional = TRUE;
  if (ParDefined(PN_CURR_WIDTH))
    arg[1].v.intVal = ParGetIntVal(PN_CURR_WIDTH);
  else
    arg[1].v.intVal = 1000;

  arg[2].prompt = "Height";
  arg[2].optional = TRUE;
  if (ParDefined(PN_CURR_HEIGHT))
    arg[2].v.intVal = ParGetIntVal(PN_CURR_HEIGHT);
  else
    arg[2].v.intVal = 750;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  if (arg[0].v.intVal == 0) {
    width = arg[1].v.intVal;
    height = arg[2].v.intVal;
    PuSetDrawSize(width, height);
    /* CURR_WIDTH and CURR_HEIGHT are automatically updated via
       the resize callback */
  } else if (arg[0].v.intVal == 1) {
    ParSetIntVal(PN_SAVE_WIDTH, arg[1].v.intVal);
    ParSetIntVal(PN_SAVE_HEIGHT, arg[2].v.intVal);
  } else if (ParDefined(PN_SAVE_WIDTH) && ParDefined(PN_SAVE_HEIGHT)) {
    width = ParGetIntVal(PN_SAVE_WIDTH);
    height = ParGetIntVal(PN_SAVE_HEIGHT);
    PuSetDrawSize(width, height);
  }

  ArgCleanup(arg, ARG_NUM);

  return EC_OK;
}
