/*
************************************************************************
*
*   ExDrawPrec.c - DrawPrec command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExDrawPrec.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <sg.h>
#include <arg.h>
#include <par_names.h>
#include <par_hand.h>
#include <graph_draw.h>

#define MAX_PREC 5

#define ARG_NUM 1

ErrCode
ExDrawPrec(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  int prec;

  arg[0].type = AT_INT;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Drawing Precision";
  arg[0].v.intVal = ParGetIntVal(PN_DRAW_PREC);

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  prec = arg[0].v.intVal;
  ArgCleanup(arg, ARG_NUM);

  if (prec < 0)
    prec = 0;
  else if (prec > MAX_PREC)
    prec = MAX_PREC;

  ParSetIntVal(PN_DRAW_PREC, prec);
  SgSetPrecision(prec);

  GraphRedrawNeeded();

  return EC_OK;
}
