/*
************************************************************************
*
*   ExRemovePrim.c - RemovePrim command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdprim/SCCS/s.ExRemovePrim.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_prim.h>

#include <stdio.h>

#include <prim_hand.h>
#include <graph_draw.h>

static void
removePrim(PrimObjP primP, void *clientData)
{
  PrimDestroy(primP);
}

ErrCode
ExRemovePrim(char *cmd)
{
  PrimApply(PT_ALL, PropGetRef(PROP_SELECTED, FALSE), removePrim, NULL);

  GraphSpecChanged(PROP_ALL);
  GraphRedrawNeeded();

  return EC_OK;
}
