/*
************************************************************************
*
*   ExXMac.c - XMac command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdmisc/SCCS/s.ExXMac.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_misc.h>

#include <string.h>

#include <dstr.h>
#include <arg.h>
#include <prog_dir.h>
#include <curr_dir.h>
#include <cip.h>

#define NAME_PATTERN "*.mac"

ErrCode
ExXMac(char *cmd)
{
  DSTR fileName, dirName, fullName;
  ErrCode errCode;

  dirName = DStrNew();
  if (strcmp(cmd, "XMacUser") == 0) {
    DStrAssignStr(dirName, CurrDirGet());
  } else {
    DStrAssignStr(dirName, ProgDirGet());
    DStrAppStr(dirName, "/macros");
  }

  fileName = DStrNew();
  errCode = ArgGetFilename(fileName, DStrToStr(dirName), NAME_PATTERN);

  if (errCode != EC_OK) {
    DStrFree(dirName);
    DStrFree(fileName);
    return errCode;
  }

  fullName = DStrNew();
  if (DStrToStr(fileName)[0] == '/') {
    DStrAssignDStr(fullName, fileName);
  } else {
    DStrAssignDStr(fullName, dirName);
    DStrAppChar(fullName, '/');
    DStrAppDStr(fullName, fileName);
  }

  errCode = CipExecFile(DStrToStr(fullName));

  DStrFree(dirName);
  DStrFree(fileName);
  DStrFree(fullName);

  return errCode;
}
