/*
************************************************************************
*
*   ExRegister.c - Register command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdmisc/SCCS/s.ExRegister.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_misc.h>

#include <stdio.h>

#include <dstr.h>
#include <os_mail.h>
#include <prog_vers.h>
#include <contact_addr.h>
#include <pu.h>
#include <arg.h>

#define ARG_NUM 5

static char *FieldNames[] = {
  "Name",
  "Organisation",
  "Address",
  "E-mail",
  "Program"
};

ErrCode
ExRegister(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  DSTR msg;
  char buf[30];
  int i;

  for (i = 0; i < ARG_NUM; i++)
    arg[i].type = AT_STR;

  ArgInit(arg, ARG_NUM);

  for (i = 0; i < ARG_NUM; i++)
    arg[i].prompt = FieldNames[i];

  DStrAssignStr(arg[4].v.strVal, PROG_NAME);
  (void) sprintf(buf, " %d.%d.%d", VERS_MAJOR, VERS_MINOR, VERS_REV);
  DStrAppStr(arg[4].v.strVal, buf);
  arg[4].optional = TRUE;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  msg = DStrNew();

  for (i = 0; i < ARG_NUM; i++) {
    DStrAppStr(msg, FieldNames[i]);
    DStrAppStr(msg, ": ");
    DStrAppDStr(msg, arg[i].v.strVal);
    DStrAppStr(msg, "\n");
  }

  if (OsMail("registration", DStrToStr(msg)))
    PuShowMessage(PU_MT_INFO, cmd, "E-mail sent");
  else
    PuShowMessage(PU_MT_INFO, cmd, "E-mail could not be sent");

  DStrFree(msg);

  ArgCleanup(arg, ARG_NUM);

  return EC_OK;
}
