/*
************************************************************************
*
*   ExMemory.c - Memory command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdmisc/SCCS/s.ExMemory.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_misc.h>

#include <arg.h>
#include <ndio/ndio.h>

static int MemLimit = 4;

ErrCode
ExMemory(char *cmd)
{
  ArgDescr arg;
  ErrCode errCode;

  arg.type = AT_INT;

  ArgInit(&arg, 1);

  arg.prompt = "Memory (MBytes)";
  arg.v.intVal = MemLimit;

  errCode = ArgGet(&arg, 1);
  if (errCode != EC_OK) {
    ArgCleanup(&arg, 1);
    return errCode;
  }

  MemLimit = arg.v.intVal;

  ArgCleanup(&arg, 1);

  NdioSetMemLimit(MemLimit * 1024 * 1024);

  return EC_OK;
}
